<?php
/**
 * Header Search Overlay.
 *
 * @package Total WordPress theme
 * @subpackage Partials
 * @version 5.6
 */

use TotalTheme\Header\Menu\Search;

?>

<div id="wpex-searchform-overlay" class="header-searchform-wrap wpex-fs-overlay wpex-text-center" data-placeholder="<?php echo esc_attr( Search::get_placeholder_text() ); ?>" data-disable-autocomplete="true">
	<button class="wpex-close">
		<span class="wpex-close__icon" aria-hidden="true">&times;</span>
		<span class="screen-reader-text"><?php esc_html_e( 'Close search', 'total' ); ?></span>
	</button>
	<div class="wpex-inner wpex-scale">
		<?php wpex_hook_header_search_overlay_top(); ?>
		<div class="wpex-title"><?php esc_html_e( 'Search', 'total' ); ?></div>
		<?php echo Search::get_form(); ?>
		<?php wpex_hook_header_search_overlay_bottom(); ?>
	</div>
</div>