<?php
/**
 * Returns last modified date block for use with meta element.
 *
 * @package TotalTheme
 * @subpackage Partials\Meta\Blocks
 * @version 5.4.6
 */

defined( 'ABSPATH' ) || exit;

$format   = $args['format'] ?? get_option( 'date_format' );
$singular = $args['singular'] ?? true;
$icon     = $args['icon'] ?? 'clock-o';

if ( $singular ) { ?>
    <li class="meta-date-modified"><?php wpex_theme_icon_html( $icon, 'meta-icon' ); ?><time class="updated" datetime="<?php echo esc_attr( get_the_modified_date( 'Y-m-d' ) ); ?>"<?php wpex_schema_markup( 'date_modified' ); ?>><?php the_modified_date( $format ); ?></time></li>
<?php } else { ?>
    <li class="meta-date-modified"><?php wpex_theme_icon_html( $icon, 'meta-icon' ); ?><time class="updated" datetime="<?php echo esc_attr( get_the_modified_date( 'Y-m-d' ) ); ?>"><?php the_modified_date( $format ); ?></time></li>
<?php } ?>