<?php
/**
 * Footer Builder Content
 *
 * @package TotalTheme
 * @subpackage Partials
 * @version 5.7.0
 *
 * @todo remove the entry classname from footer-builder-content
 */

defined( 'ABSPATH' ) || exit;

$id = wpex_footer_builder_id();

if ( ! $id && empty( $_GET[ 'wpex_inline_footer_template_editor' ] ) ) {
	return;
}

?>

<footer id="footer-builder" class="footer-builder"<?php wpex_schema_markup( 'footer' ); ?>>
	<div class="footer-builder-content container entry wpex-clr">
		<?php
		if ( wpex_is_footer_builder_page() && ( wpex_vc_is_inline() || wpex_elementor_is_preview_mode() ) ) {
			while ( have_posts() ) : the_post();
				the_content();
			endwhile;
		} else {
			if ( 'elementor_library' == get_post_type( $id ) && class_exists( 'Elementor\Frontend' ) ) {
				echo wpex_get_elementor_content_for_display( $id );
			} else {
				$content = get_post_field( 'post_content', $id );
				$content = wpex_sanitize_template_content( $content );
				echo apply_filters( 'wpex_footer_builder_content', $content ); // apply filters and echo content
			}
		} ?>
	</div>
</footer>