<?php
namespace TotalTheme\Widgets;

use TotalTheme\Helpers\Register_Widget_Area;

defined( 'ABSPATH' ) || exit;

/**
 * Register Widget Areas
 *
 * @package TotalTheme
 * @subpackage Widgets
 * @version 5.6.1
 */
class Register_Widget_Areas {

	/**
	 * Class instance.
	 *
	 * @access private
	 * @var object Class object.
	 */
	private static $instance;

	/**
	 * Create or retrieve the instance of this class.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
			static::$instance->init_hooks();
		}
		return static::$instance;
	}

	/**
	 * Add Hooks.
	 */
	protected function init_hooks() {
		add_action( 'widgets_init', [ $this, 'register_sidebar_areas' ] );
		add_action( 'widgets_init', [ $this, 'register_footer_areas' ], 40 );
	}

	/**
	 * Register sidebar areas.
	 */
	public function register_sidebar_areas() {
		$sidebars = [
			'sidebar' => esc_html__( 'Main Sidebar', 'total' ),
		];

		// Pages Sidebar.
		if ( get_theme_mod( 'pages_custom_sidebar', true ) ) {
			$sidebars['pages_sidebar'] = esc_html__( 'Pages Sidebar', 'total' );
		}

		// Blog Sidebar.
		if ( get_theme_mod( 'blog_custom_sidebar', false ) ) {
			$sidebars['blog_sidebar'] = esc_html__( 'Blog Sidebar', 'total' );
		}

		// Search Results Sidebar.
		if ( get_theme_mod( 'search_custom_sidebar', true ) ) {
			$sidebars['search_sidebar'] = esc_html__( 'Search Results Sidebar', 'total' );
		}

		// WooCommerce.
		if ( WPEX_WOOCOMMERCE_ACTIVE && get_theme_mod( 'woo_custom_sidebar', true ) ) {
			$sidebars['woo_sidebar'] = esc_html__( 'WooCommerce Sidebar', 'total' );
		}

		/**
		 * Filters the array of sidebars to be registered.
		 *
		 * @param array $sidebars. Sidebars array with the format: widget_id => widget_name
		 */
		$sidebars = (array) apply_filters( 'wpex_register_sidebars_array', $sidebars );

		if ( ! $sidebars ) {
			return;
		}

		foreach ( $sidebars as $k => $v ) {
			if ( is_array( $v ) ) {
				$args = $args;
			} else {
				$args = [
					'id' => $k,
					'name' => $v,
				];
			}
			new Register_Widget_Area( 'sidebar', $args );
		}
	}

	/**
	 * Register footer areas.
	 */
	public function register_footer_areas() {
		if ( wpex_has_custom_footer() ) {
			$maybe_register = get_theme_mod( 'footer_builder_footer_widgets', false );
		} else {
			$maybe_register = get_theme_mod( 'footer_widgets', true );
		}

		/**
		 * Filters whether the footer has widgets or not.
		 *
		 * @param bool $maybe_register
		 * @todo rename filter to "wpex_maybe_register_footer_widget_areas".
		 */
		$maybe_register = apply_filters( 'wpex_register_footer_sidebars', $maybe_register );

		if ( ! $maybe_register ) {
			return;
		}

		// Footer widget columns.
		$footer_columns = (int) get_theme_mod( 'footer_widgets_columns', 4 );

		// Check if we are in the customizer.
		$customizing = is_customize_preview();

		// Footer 1.
		new Register_Widget_Area( 'footer', [
			'name' => esc_html__( 'Footer Column 1', 'total' ),
			'id'   => 'footer_one',
		] );

		// Footer 2.
		if ( $footer_columns > 1 || $customizing ) {
			new Register_Widget_Area( 'footer', [
				'name' => esc_html__( 'Footer Column 2', 'total' ),
				'id' => 'footer_two',
			] );
		}

		// Footer 3.
		if ( $footer_columns > 2 || $customizing ) {
			new Register_Widget_Area( 'footer', [
				'name' => esc_html__( 'Footer Column 3', 'total' ),
				'id' => 'footer_three',
			] );
		}

		// Footer 4.
		if ( $footer_columns > 3 || $customizing ) {
			new Register_Widget_Area( 'footer', [
				'name' => esc_html__( 'Footer Column 4', 'total' ),
				'id' => 'footer_four',
			] );
		}

		// Footer 5.
		if ( $footer_columns > 4 || $customizing ) {
			new Register_Widget_Area( 'footer', [
				'name' => esc_html__( 'Footer Column 5', 'total' ),
				'id' => 'footer_five',
			] );
		}

		// Footer 6.
		if ( $footer_columns > 5 || $customizing ) {
			new Register_Widget_Area( 'footer', [
				'name' => esc_html__( 'Footer Column 6', 'total' ),
				'id' => 'footer_six',
			] );
		}
	}

}