<?php
namespace TotalTheme\Theme_Builder;

use TotalTheme\Theme_Builder as Builder;
use TotalTheme\Theme_Builder\Post_Template;
use TotalTheme\Integration\WPBakery\Shortcode_Inline_Style as WPB_Style;

defined( 'ABSPATH' ) || exit;

/**
 * Theme Builder > Render Template
 *
 * @package TotalTheme
 * @subpackage Theme_Builder
 * @version 5.7.0
 */
class Render_Template extends Builder {

	/**
	 * Template to render.
	 */
	protected $template;

	/**
	 * Location where template is being displayed.
	 */
	protected $location;

	/**
	 * Render the template.
	 */
	public function __construct( $template, $location ) {
		$this->template = $template;
		$this->location = $location;
	}

	/**
	 * Render the template.
	 */
	public function render() {
		if ( empty( $this->template ) ) {
			return false;
		}

		if ( 'single' === $this->location && post_password_required() ) {
			the_content();
			return true;
		}

		$template_content = $this->get_template_content();

		if ( empty( $template_content ) ) {
			return;
		}

		self::$did_locations[] = $this->location;

		$this->before_template();

		if ( 'single' === $this->location ) {
			/**
			 * Loop is very important, otherwise frontend editor won't work. And we must
			 * check to ensure we aren't already in the loop to prevent infinite loop.
			 */
			if ( ! in_the_loop() ) {
				while ( have_posts() ) : the_post();
					Post_Template::render_template( $template_content );
				endwhile;
			} else {
				Post_Template::render_template( $template_content );
			}
		} else {
			echo wpex_sanitize_template_content( $template_content );
		}

		$this->after_template();

		return true;
	}

	/**
	 * Returns the template content.
	 */
	protected function get_template_content() {
		if ( $translated_id = wpex_parse_obj_id( $this->template, 'page' ) ) {
			$post = get_post( $translated_id );
		}

		$post = $post ?? get_post( $this->template );

		if ( $post && 'publish' === get_post_status( $post ) && ! empty( $post->post_content ) ) {
			return $post->post_content;
		}
	}

	/**
	 * Before template content.
	 */
	protected function before_template() {
		self::$current_location = $this->location;
		WPB_Style::instance()->render_style( $this->template, true );
	}

	/**
	 * After template content.
	 */
	protected function after_template() {
		self::$current_location = null;
	}

}