<?php
/**
 * Helper functions for the theme builder features.
 *
 * @package TotalTheme
 * @version 5.5
 */

defined( 'ABSPATH' ) || exit;

/*-------------------------------------------------------------------------------*/
/* [ Table of contents ]
/*-------------------------------------------------------------------------------*

	# Core
	# Header
	# Footer
	# Single (Dynamic Templates)

/*-------------------------------------------------------------------------------*/
/* [ Core ]
/*-------------------------------------------------------------------------------*/
function wpex_theme_do_location( $location = '' ) {
	return \TotalTheme\Theme_Builder::instance()->do_location( $location );
}

/*-------------------------------------------------------------------------------*/
/* [ Header ]
/*-------------------------------------------------------------------------------*/

/**
 * Get header builder ID
 */
function wpex_header_builder_id() {
	if ( class_exists( 'TotalTheme\\HeaderBuilder' ) ) {
		return TotalTheme\HeaderBuilder::get_template_id();
	}
}

/**
 * Check if we are currently in header builder edit mode.
 */
function wpex_is_header_builder_page() {
	if ( ! empty( $_GET[ 'wpex_inline_header_template_editor' ] ) ) {
		return true;
	}
	$header_builder_id = wpex_header_builder_id();
	if ( $header_builder_id && $header_builder_id == wpex_get_current_post_id() ) {
		return true;
	}
}

/*-------------------------------------------------------------------------------*/
/* [ Footer ]
/*-------------------------------------------------------------------------------*/

/**
 * Get footer builder ID.
 */
function wpex_footer_builder_id() {
	if ( class_exists( 'TotalTheme\\FooterBuilder' ) ) {
		return TotalTheme\FooterBuilder::get_template_id();
	}
}

/**
 * Check if we are currently in footer builder edit mode.
 */
function wpex_is_footer_builder_page() {
	if ( ! empty( $_GET[ 'wpex_inline_footer_template_editor' ] ) ) {
		return true;
	}
	$footer_builder_id = wpex_footer_builder_id();
	if ( $footer_builder_id && $footer_builder_id == wpex_get_current_post_id() ) {
		return true;
	}
}

/*-------------------------------------------------------------------------------*/
/* [ Single ]
/*-------------------------------------------------------------------------------*/

/**
 * Returns post ID when using a dynamic template.
 */
function wpex_get_dynamic_post_id() {
	$post_id = wpex_get_current_post_id();

	/**
	 * Filters the post ID when using dynamic templates.
	 *
	 * @param int $post_id
	 */
	$post_id = apply_filters( 'wpex_get_dynamic_post_id', $post_id );

	return $post_id;
}