<?php
namespace TotalTheme\Pagination;

defined( 'ABSPATH' ) || exit;

/**
 * Next_Prev Pagination.
 *
 * @package TotalTheme
 * @subpackage Author
 * @version 5.5
 */
class Next_Prev {

	/**
	 * The current query.
	 */
	protected $query;

	/**
	 * Constructor.
	 */
	public function __construct( $query = null )  {
		if ( $query ) {
			$this->query = $query;
		} else {
			global $wp_query;
			$this->query = $wp_query;
		}
	}

	/**
	 * Renders the pagination.
	 */
	public function render()  {
		$max_pages = absint( $this->query->max_num_pages ?? 1 );

		if ( ! $max_pages || 1 === $max_pages ) {
			return;
		}

		?>
			<div class="page-jump wpex-clr">
				<div class="alignleft newer-posts"><?php
					previous_posts_link( '&larr; ' . esc_html__( 'Newer Posts', 'total' ) );
				?></div>
				<div class="alignright older-posts"><?php
					next_posts_link( esc_html__( 'Older Posts', 'total' ) . ' &rarr;' );
				?>
				</div>
			</div>
		<?php
	}

}