<?php
namespace TotalTheme\Integration\Yoast_SEO;

defined( 'ABSPATH' ) || exit;

/**
 * Breadcrumbs for Yoast.
 *
 * @package TotalTheme
 * @subpackage Integration
 * @version 5.6.1
 */
class Breadcrumbs {

	/**
	 * Constructor.
	 */
	public function __construct() {
		if ( apply_filters( 'wpex_filter_wpseo_breadcrumb_links', true ) ) {
			add_filter( 'wpseo_breadcrumb_links', [ $this, 'modify_links' ] );
		}
		add_filter( 'wpseo_breadcrumb_single_link_info', [ $this, 'trim_the_title' ], 10, 3 );
	}

	/**
	 * Filter the ancestors of the yoast seo breadcrumbs.
	 *
	 * Adds the portfolio, staff, testimonials and blog links
	 */
	public function modify_links( $links ) {
		if ( ! class_exists( '\WPSEO_Options' ) ) {
			return $links;
		}

		$new_breadcrumb = array();

		// Loop through theme post types to add parent item.
		if ( is_singular( array( 'portfolio', 'staff', 'testimonials', 'post' ) ) ) {
			$type = get_post_type();
			if ( 'post' === $type ) {
				$type = 'blog';
			}
			$page_id = wpex_parse_obj_id( get_theme_mod( $type . '_page' ), 'page' );
			if ( $page_id ) {
				$page_title     = get_the_title( $page_id );
				$page_permalink = get_permalink( $page_id );
				if ( $page_permalink && $page_title ) {
					$new_breadcrumb[] = array(
						'url'  => $page_permalink,
						'text' => $page_title,
					);
				}
			}
		}

		// Combine new crumb.
		if ( $new_breadcrumb ) {
			if ( '' !== \WPSEO_Options::get( 'breadcrumbs-home' ) ) {
				array_splice( $links, 1, -2, $new_breadcrumb );
			} else {
				array_splice( $links, 0, -3, $new_breadcrumb );
			}
		}

		return $links;
	}

	/**
	 * Trim the Yoast SEO title.
	 */
	public function trim_the_title( $link_info, $index, $crumbs ) {
		$trim = absint( get_theme_mod( 'breadcrumbs_title_trim' ) );
		if ( $trim && is_array( $crumbs ) && ( absint( $index ) + 1 == count( $crumbs ) ) ) {
			if ( isset( $link_info['text'] ) ) {
				$link_info['text'] = wp_trim_words( $link_info['text'], $trim );
			}
		}
		return $link_info;
	}

}