<?php
namespace TotalTheme\Integration;

defined( 'ABSPATH' ) || exit;

/**
 * Yoast SEO Plugin Integration.
 *
 * @package TotalTheme
 * @subpackage Integration
 * @version 5.6.1
 */
class Yoast_SEO {

	/**
	 * Instance.
	 *
	 * @access private
	 * @var object Class object.
	 */
	private static $instance;

	/**
	 * Create or retrieve the instance of Yoast_SEO.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
			static::$instance->setup();
		}
		return static::$instance;
	}

	/**
	 * Hook into actions and filters.
	 */
	public function setup() {
		add_action( 'after_setup_theme', [ $this, 'add_theme_support' ] );

		if ( apply_filters( 'wpex_filter_wpseo_metadesc', true ) ) {
			add_filter( 'wpseo_metadesc', [ $this, 'metadesc' ] );
		}

		if ( true === wp_validate_boolean( get_theme_mod( 'enable_yoast_breadcrumbs', true ) ) ) {
			new Yoast_SEO\Breadcrumbs;
		}

		new Yoast_SEO\Pagination_Fix;
		new Yoast_SEO\Customizer;
	}

	/**
	 * Register Yoast SEO theme support.
	 */
	public function add_theme_support() {
		add_theme_support( 'yoast-seo-breadcrumbs' );
	}

	/**
	 * Auto Generate meta description if empty using Total excerpt function.
	 */
	public function metadesc( $metadesc ) {
		if ( ! $metadesc && is_singular() ) {
			$metadesc = wpex_get_excerpt( array(
				'length'    => apply_filters( 'wpex_yoast_metadesc_length', 160 ),
				'trim_type' => 'characters',
				'more'      => null,
			) );
		}
		return trim( wp_strip_all_tags( $metadesc ) );
	}

}