<?php
defined( 'ABSPATH' ) || exit;

$tag = 'script';

?>

<script>
	window.wpexTemplatesData = {
		templates: <?php echo $this->get_templates_json(); ?>
	}
</script>

<div class="vc_column vc_col-sm-12">
	<h3><?php echo esc_html( $this->get_category_name() ) ; ?></h3>
	<p class="vc_description"><?php echo wp_kses_post( $this->get_category_description() ); ?></p>
</div>

<div class="vc_column vc_col-sm-12">
	<?php $categories = $this->get_categories(); ?>
	<div class="wpex-vc-template-list__filter">
		<span><?php esc_html_e( 'Filter by type', 'total' ); ?>:</span>
		<a href="#" data-category="*" aria-pressed="true" role="button" class="wpex-vc-template-list__filter-button"><?php esc_html_e( 'All', 'total' ); ?></a>
		<?php foreach( $categories as $cat_id => $cat_name ) { ?>
			<a href="#" data-category="<?php echo esc_attr( $cat_id ); ?>" aria-pressed="false" role="button" class="wpex-vc-template-list__filter-button"><?php echo esc_html( $cat_name ); ?></a>
		<?php } ?>
	</div>
</div>

<div class="vc_column vc_col-sm-12">
	<div class="wpex-vc-template-list">
		<<?php echo esc_attr( $tag ); ?> type="text/html" id="wpex_template-item">
			<div class="wpex-vc-template-list__item"
				data-template_id="<%- id %>"
				data-template_id_hash="<%- id_hash %>"
				data-template_unique_id="<%- unique_id %>"
				data-wpex-category="<%- u=category %>"
				data-template_name="<%- u=name %>"
				data-template_type="<?php echo esc_attr( self::TEMPLATE_TYPE ); ?>"
				data-category="<?php echo esc_attr( self::TEMPLATE_TYPE ); ?>"
			>

			<div class="wpex-vc-template-list__image"><img loading="lazy" src="<%- screenshot %>"></div>

			<div class="wpex-vc-template-list__overlay">

			<div class="wpex-vc-template-list__name"><%- label %></div>
				<div class="wpex-vc-template-list__actions">
					<a href="https://total.wpexplorer.com/sections/wpbakery/<%- id %>" class="button button-primary" target="_blank" rel="nofollow noopener noreferrer"><?php esc_html_e( 'Preview', 'total' ); ?><svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 0 24 24" width="24px" fill="currentColor"><path d="M0 0h24v24H0V0z" fill="none"/><path d="M12 6.5c3.79 0 7.17 2.13 8.82 5.5-1.65 3.37-5.02 5.5-8.82 5.5S4.83 15.37 3.18 12C4.83 8.63 8.21 6.5 12 6.5m0-2C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zm0 5c1.38 0 2.5 1.12 2.5 2.5s-1.12 2.5-2.5 2.5-2.5-1.12-2.5-2.5 1.12-2.5 2.5-2.5m0-2c-2.48 0-4.5 2.02-4.5 4.5s2.02 4.5 4.5 4.5 4.5-2.02 4.5-4.5-2.02-4.5-4.5-4.5z"/></svg></a>
					<button type="button" class="wpex-vc-template-list__insert button button-primary" data-template-handler=""><?php esc_html_e( 'Insert', 'total' ); ?><svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" height="24px" viewBox="0 0 24 24" width="24px" fill="currentColor"><g><rect fill="none" height="24" width="24"/></g><g><path d="M18,15v3H6v-3H4v3c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2v-3H18z M17,11l-1.41-1.41L13,12.17V4h-2v8.17L8.41,9.59L7,11l5,5 L17,11z"/></g></svg></button></div>
				</div>
			</div>
		</<?php echo esc_attr( $tag ); ?>>
	</div>
</div>