<?php
namespace TotalTheme\Integration\WooCommerce;

defined( 'ABSPATH' ) || exit;

/**
 * WooCommerce Titles.
 *
 * @package TotalTheme
 * @subpackage Integration/WooCommerce
 * @version 5.6.1
 */
class Title {

	/**
	 * Returns correct WooCommerce title.
	 */
	public function get() {
		if ( wpex_is_woo_shop() ) {
			return $this->get_shop_title();
		}

		if ( is_product() ) {
			return $this->get_single_product_title();
		}

		if ( is_order_received_page() ) {
			return esc_html__( 'Order Received', 'total' );
		}
	}

	/**
	 * Get the WooCommerce shop title.
	 */
	protected function get_shop_title() {
		if ( ! empty( $_GET['s'] ) ) {
			return esc_html__( 'Shop results for:', 'total' ) . ' <span>&quot;' . esc_html( $_GET['s'] ) . '&quot;</span>';
		} else {
			if ( $shop_id = wpex_parse_obj_id( wc_get_page_id( 'shop' ), 'page' ) ) {
				return get_the_title( $shop_id );
			}
			return esc_html__( 'Shop', 'total' );
		}
	}

	/**
	 * Get the WooCommerce single product title.
	 */
	protected function get_single_product_title() {
		return wpex_get_translated_theme_mod( 'woo_shop_single_title' ) ?: esc_html__( 'Shop', 'total' );
	}

}