<?php
/**
 * Sensei Customizer Settings.
 *
 * @package TotalTheme
 * @subpackage Integration/Learn_Dash
 * @version 5.4
 */

defined( 'ABSPATH' ) || exit;

// Global settings.
$this->sections['wpex_sensei_general'] = array(
	'title' => esc_html__( 'General', 'total' ),
	'panel' => 'wpex_sensei',
	'settings' => array(
		array(
			'id' => 'sensei_page_layout',
			'control' => array(
				'label' => esc_html__( 'Global Layout', 'total' ),
				'type' => 'select',
				'choices' => 'post_layout',
				'description' => esc_html__( 'Set your default layout for all Sensie pages.', 'total' ),
			),
		),
		array(
			'id' => 'sensei_learner_profile_layout',
			'control' => array(
				'label' => esc_html__( 'Learner Profile Layout', 'total' ),
				'type' => 'select',
				'choices' => 'post_layout',
			),
		),
		array(
			'id' => 'sensei_quiz_layout',
			'control' => array(
				'label' => esc_html__( 'Quiz Layout', 'total' ),
				'type' => 'select',
				'choices' => 'post_layout',
			),
		)
	),
);

// Post type settings.

$single_blocks = array(
	'media'       => esc_attr__( 'Media (Thumbnail, Slider, Video)', 'total' ),
	'title'       => esc_attr__( 'Title', 'total' ),
	'meta'        => esc_attr__( 'Meta', 'total' ),
	'content'     => esc_attr__( 'Content', 'total' ),
	'share'       => esc_attr__( 'Social Share', 'total' ),
);

$single_defaults = array_keys( $single_blocks );

$post_types = array(
	'course' => esc_html__( 'Courses', 'total' ),
	'lesson' => esc_html__( 'Lessons', 'total' ),
);

foreach ( $post_types as $post_type => $post_type_name ) {

	$settings = array();

	// Bail if post type not registered
	if ( ! post_type_exists( $post_type ) ) {
		continue;
	}


	if ( 'course' === $post_type || 'lesson' === $post_type || 'question' === $post_type ) {

		$settings[] = array(
			'id' => $post_type . '_archive_heading',
			'default' => true,
			'control' => array(
				'type' => 'wpex-heading',
				'label' => esc_html__( 'Archive Settings', 'total' ),
			),
		);

		$settings[] = array(
			'id' => $post_type . '_archives_layout',
			'control' => array(
				'label' => esc_html__( 'Archives Layout', 'total' ),
				'type' => 'select',
				'choices' => 'post_layout',
			),
		);

		$settings[] = array(
			'id' => $post_type . '_archive_has_page_header',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Display Page Header Title?', 'total' ),
				'type' => 'checkbox',
			),
			/*'control_display' => array(
				'check' => 'page_header_style',
				'vale' => 'hidden',
				'compare' => 'not_equal',
			),*/
		);

	}

	$settings[] = array(
		'id' => $post_type . '_single_heading',
		'default' => true,
		'control' => array(
			'type' => 'wpex-heading',
			'label' => esc_html__( 'Post Settings', 'total' ),
		),
	);

	$settings[] = array(
		'id' => $post_type . '_singular_page_title',
		'default' => true,
		'control' => array(
			'label' => esc_html__( 'Display Page Header Title?', 'total' ),
			'type' => 'checkbox',
		),
		/*'control_display' => array(
			'check' => 'page_header_style',
			'vale' => 'hidden',
			'compare' => 'not_equal',
		),*/
	);

	$settings[] = array(
		'id' => $post_type . '_single_layout',
		'control' => array(
			'label' => esc_html__( 'Single Layout', 'total' ),
			'type' => 'select',
			'choices' => 'post_layout',
		),
	);

	$settings[] = array(
		'id' => $post_type . '_single_header',
		'control' => array(
			'label' => esc_html__( 'Single Header Display', 'total' ),
			'type' => 'select',
			'choices' => array(
				'' => esc_html__( 'Default','total' ),
				'post_title' => esc_html__( 'Post Title','total' ),
			),
		),
	);

	if ( 'lesson' !== $post_type ) {

		$settings[] = array(
			'id' => $post_type . '_single_blocks',
			'default' => $single_defaults,
			'control' => array(
				'label' => esc_html__( 'Single Blocks', 'total' ),
				'type' => 'wpex_multi_select',
				'choices' => $single_blocks,
			),
		);

	}

	$this->sections['wpex_sensei_' . $post_type ] = array(
		'title' => $post_type_name,
		'panel' => 'wpex_sensei',
		'settings' => $settings,
	);

}