<?php
namespace TotalTheme\Integration;

defined( 'ABSPATH' ) || exit;

/**
 * Gutenberg Integration Class.
 *
 * @package TotalTheme
 * @subpackage Integration
 * @version 5.6.1
 */
class Gutenberg {

	/**
	 * Instance.
	 */
	private static $instance;

	/**
	 * Create or retrieve the class instance.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
		}

		return static::$instance;
	}

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'after_setup_theme', [ $this, 'add_theme_support' ] );
		add_action( 'init', [ $this, 'init' ] );
	}

	/**
	 * Define theme support for Gutenberg via add_theme_support.
	 */
	public function add_theme_support() {
		if ( ! $this->is_block_editor_enabled() ) {
			return;
		}

		add_theme_support( 'gutenberg-editor' );

		if ( apply_filters( 'wpex_color_palette_gutenberg_support', true ) ) {
			Gutenberg\Editor_Color_Palette::register_colors();
		}
	}

	/**
	 * Runs on init.
	 */
	public function init() {
		if ( current_theme_supports( 'gutenberg-editor' ) ) {
			$this->enabled();
		} else {
			$this->disabled();
		}
	}

	/**
	 * Runs when Gutenberg is enabled.
	 */
	private function enabled() {
		if ( apply_filters( 'wpex_has_block_gallery_lightbox_integration', true ) ) {
			Gutenberg\Block_Gallery_Lightbox::instance();
		}
	}

	/**
	 * Runs when Gutenberg is disabled.
	 */
	private function disabled() {
		if ( apply_filters( 'wpex_remove_block_library_css', true ) ) {
			Gutenberg\Remove_Scripts::instance();
		}
	}

	/**
	 * Checks if the block editor is enabled.
	 */
	public function is_block_editor_enabled() {
		$check = true;
		if ( class_exists( 'Classic_Editor' ) || ( WPEX_VC_ACTIVE && get_option( 'wpb_js_gutenberg_disable' ) ) ) {
			$check = false;
		}
		return $check; // @todo apply filters.
	}

}