<?php
namespace TotalTheme\Integration;

defined( 'ABSPATH' ) || exit;

/**
 * Contact Form 7 Integration.
 *
 * @package TotalTheme
 * @subpackage TotalTheme\Integration
 * @version 5.5
 */
final class Contact_Form_7 {

	/**
	 * Instance.
	 */
	private static $instance;

	/**
	 * Create or retrieve the instance of Contact_Form_7.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
		}

		return static::$instance;
	}

	/**
	 * Hook into actions and filters.
	 */
	public function __construct() {
		add_action( 'wp_enqueue_scripts', __CLASS__ . '::register_theme_css' );
		if ( wpex_is_request( 'frontend' ) ) {
			add_action( 'wpcf7_contact_form', __CLASS__ . '::enqueue_theme_css' );
		}
	}

	/**
	 * Register custom theme css for Contact Form 7.
	 */
	public static function register_theme_css() {
		wp_register_style(
			'wpex-contact-form-7',
			wpex_asset_url( 'css/wpex-contact-form-7.css' ),
			array( 'contact-form-7' ),
			WPEX_THEME_VERSION
		);
	}

	/**
	 * Enqueues theme CSS for Contact Form 7.
	 */
	public static function enqueue_theme_css() {
		wp_enqueue_style( 'wpex-contact-form-7' );
	}

}