<?php
namespace TotalTheme\Integration;

defined( 'ABSPATH' ) || exit;

/**
 * bbPress Integration.
 *
 * @package TotalTheme
 * @subpackage BuddyPress
 * @version 5.4
 */
final class BuddyPress {

	/**
	 * Instance.
	 *
	 * @access private
	 * @var object Class object.
	 */
	private static $instance;

	/**
	 * Create or retrieve the instance of BuddyPress.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
		}

		return static::$instance;
	}

	/**
	 * Hook into actions and filters.
	 */
	public function __construct() {
		define( 'WPEX_BUDDYPRESS_DIR', WPEX_INC_DIR . 'integration/buddypress/' );
		add_action( 'wp_enqueue_scripts', __CLASS__ . '::scripts', 20 );
		add_filter( 'wpex_has_page_header', __CLASS__ . '::has_page_header' );
		add_filter( 'wpex_post_layout_class', __CLASS__ . '::layouts', 11 ); // on 11 due to buddyPress issues
		add_filter( 'wpex_customizer_panels', __CLASS__ . '::add_customizer_panel' );
	}

	/**
	 * Load custom CSS.
	 */
	public static function scripts() {
		if ( ! get_theme_mod( 'bp_enqueue_theme_styles', true ) ) {
			return;
		}

		$deps = array();

		if ( wp_style_is( 'bp-nouveau' ) ) {
			$deps[] = 'bp-nouveau';
		}

		wp_enqueue_style(
			'wpex-buddypress',
			wpex_asset_url( 'css/wpex-buddypress.css' ),
			$deps,
			WPEX_THEME_VERSION
		);
	}

	/**
	 * Enable or disable page header.
	 */
	public static function has_page_header( $check ) {
		if ( ! is_buddypress() ) {
			return $check;
		}
		if ( bp_is_directory() ) {
			if ( ! get_theme_mod( 'bp_directory_page_title', true ) ) {
				$check = false;
			}
		} elseif ( bp_is_user() ) {
			if ( ! get_theme_mod( 'bp_user_singular_page_title', true ) ) {
				$check = false;
			}
		}
		return $check;
	}

	/**
	 * Set layouts.
	 */
	public static function layouts( $layout ) {
		if ( is_buddypress() ) {
			$layout = get_theme_mod( 'bp_layout' ) ?: wpex_get_default_content_area_layout();
			if ( bp_is_directory() ) {
				$layout = get_theme_mod( 'bp_directory_layout' ) ?: $layout;
			} elseif ( bp_is_user() ) {
				$layout = get_theme_mod( 'bp_user_layout' ) ?: $layout;
			}
		}
		return $layout;
	}

	/**
	 * Adds new Customizer Panel for bbPress.
	 */
	public static function add_customizer_panel( $panels ) {
		$panels['buddypress'] = array(
			'title'    => esc_html__( 'BuddyPress (Total)', 'total' ),
			'settings' => WPEX_BUDDYPRESS_DIR . 'customizer-settings.php'
		);
		return $panels;
	}

}