<?php
namespace TotalTheme\Helpers;

use TotalTheme\Sidebars\Primary as Primary_Sidebar;
use TotalTheme\Footer\Widgets as Footer_Widgets;

defined( 'ABSPATH' ) || exit;

/**
 * Registers a new widget area with WP.
 *
 * @package TotalTheme
 * @subpackage Header
 * @version 5.6.1
 */
class Register_Widget_Area {

	/**
	 * Constructor.
	 */
	public function __construct( $location = '', $args = [] ) {
		$method = 'register_' . $location . '_widget_area';

		if ( method_exists( $this, $method) ) {
			$this->$method( $args );
		}
	}

	/**
	 * Registers a new sidebar widget area.
	 */
	protected function register_sidebar_widget_area( $args = [] ) {
		$widget_class = 'sidebar-box widget %2$s wpex-mb-30 wpex-clr';

		/**
		 * Filters the sidebar widget class.
		 *
		 * @param string $class
		 */
		$widget_class = apply_filters( 'wpex_sidebar_widget_class', $widget_class );

		$default_args = [
			'before_widget' => '<div id="%1$s" class="' . esc_attr( $widget_class ) . '">',
			'after_widget'  => '</div>',
			'before_title'  => Primary_Sidebar::widget_title_args()['before'],
			'after_title'   => Primary_Sidebar::widget_title_args()['after'],
		];

		$args = wp_parse_args( $args, $default_args );

		if ( empty( $args['id'] ) ) {
			return;
		}

		register_sidebar( $args );
	}

	/**
	 * Registers a new footer widget area.
	 */
	protected function register_footer_widget_area( $args = [] ) {
		$widget_class = 'footer-widget widget wpex-pb-40 wpex-clr %2$s';

		/**
		 * Filters the footer widget class.
		 *
		 * @param string $class
		 */
		$widget_class = apply_filters( 'wpex_footer_widget_class', $widget_class );

		$default_args = [
			'before_widget' => '<div id="%1$s" class="' . esc_attr( $widget_class ) . '">',
			'after_widget'  => '</div>',
			'before_title'  => Footer_Widgets::widget_title_args()['before'],
			'after_title'   => Footer_Widgets::widget_title_args()['after'],
		];

		$args = wp_parse_args( $args, $default_args );

		if ( empty( $args['id'] ) ) {
			return;
		}

		register_sidebar( $args );
	}

}