<?php
namespace TotalTheme\Header\Flex;

defined( 'ABSPATH' ) || exit;

use \TotalTheme\Header\Core as Header;

/**
 * Flex Header Aside.
 *
 * @package TotalTheme
 * @subpackage Header
 * @version 5.6.1
 */
class Aside {

	/**
	 * Returns the wrapper class.
	 */
	public static function wrapper_class() {
		$header_style = Header::style();

		$class = [
			'wpex-flex',
			'wpex-items-center',
			'wpex-justify-end',
			'wpex-h-100',
		];

		if ( $header_style ) {
			$class[] = 'header-' . sanitize_html_class( $header_style ) . '-aside';
		}

		$visibility = get_theme_mod( 'header_flex_aside_visibility' );

		if ( ! empty( $visibility ) ) {
			$class[] = wpex_visibility_class( $visibility );
		}

		/**
		 * Filters the header aside element class.
		 *
		 * @param array $class
		 */
		$class = (array) apply_filters( 'totaltheme/header/flex/aside/wrapper_class', $class );

		/*** deprecated **/
		$class = (array) apply_filters( 'wpex_header_flex_aside_class', $class );

		if ( $class ) {
			echo 'class="' . esc_attr( implode( ' ', $class ) ) . '"';
		}
	}

	/**
	 * Return header aside content.
	 */
	public static function get_content() {
		$content = wpex_get_translated_theme_mod( 'header_flex_aside_content' );

		/**
		 * Filters if the header flex aside content.
		 *
		 * @param string $content
		 */
		$content = (string) apply_filters( 'totaltheme/header/flex/aside/content', $content );

		/*** deprecated ***/
		$content = apply_filters( 'wpex_header_flex_aside_content', $content );

		return $content;
	}

}