<?php
defined( 'ABSPATH' ) || exit;

/**
 * Returns array of recommended plugins.
 */
function wpex_recommended_plugins() {
	$plugins = [];

	// Required Plugins.
	$plugins['total-theme-core'] = [
		'name'               => 'Total Theme Core',
		'slug'               => 'total-theme-core',
		'version'            => WPEX_THEME_CORE_PLUGIN_SUPPORTED_VERSION,
		'source'             => 'https://totalwptheme.s3.us-east-1.amazonaws.com/plugins/total-theme-core/version-1-6-0/total-theme-core.zip',
		'required'           => true,
		'force_activation'   => false,
	];

	// Non-required Plugins.
	$excluded_plugins = get_theme_mod( 'excluded_plugins' );

	if ( ! is_array( $excluded_plugins ) ) {
		$excluded_plugins = [];
	}

	if ( ! in_array( 'js_composer', $excluded_plugins ) ) {

		$plugins['js_composer'] = [
			'name'              => 'WPBakery Page Builder',
			'slug'              => 'js_composer',
			'version'           => WPEX_VC_SUPPORTED_VERSION,
			'source'            => 'https://totalwptheme.s3.us-east-1.amazonaws.com/plugins/wpbakery/version-6-9-0/js_composer.zip',
			'required'          => false,
			'force_activation'  => false,
		];

		if ( ! in_array( 'templatera', $excluded_plugins ) ) {
			$plugins['templatera'] = [
				'name'             => 'Templatera',
				'slug'             => 'templatera',
				'source'           => 'https://totalwptheme.s3.us-east-1.amazonaws.com/plugins/templatera/version-2-0-5/templatera.zip',
				'version'          => '2.0.5',
				'required'         => false,
				'force_activation' => false,
			];
		}

	}

	if ( ! in_array( 'revslider', $excluded_plugins ) ) {
		$plugins['revslider'] = [
			'name'             => 'Slider Revolution',
			'slug'             => 'revslider',
			'version'          => '6.6.9',
			'source'           => 'https://totalwptheme.s3.us-east-1.amazonaws.com/plugins/revslider/version-6-6-9/revslider.zip',
			'required'         => false,
			'force_activation' => false,
		];
	}

	/**
	 * Filters the recommended plugins list.
	 *
	 * @param array $plugins
	 */
	$plugins = (array) apply_filters( 'wpex_recommended_plugins', $plugins );

	return $plugins;
}

/**
 * Register recommended plugins with the tgmpa script.
 */
if ( is_admin() && get_theme_mod( 'recommend_plugins_enable', true ) ) {
	if ( ! class_exists( 'TGM_Plugin_Activation' ) ) {
		require_once WPEX_INC_DIR . 'lib/tgmpa/class-tgm-plugin-activation.php';
	}

	function wpex_tgmpa_register() {
		$plugins = wpex_recommended_plugins();

		$dismissable = true;

		if ( WPEX_VC_ACTIVE ) {
			if ( wpex_vc_theme_mode_check() ) {
				$dismissable = (bool) wpex_vc_is_supported();
			} else {
				unset( $plugins['js_composer'] );
			}
		}

		tgmpa( $plugins, [
			'id'           => 'wpex_theme',
			'domain'       => 'total',
			'menu'         => 'install-required-plugins',
			'has_notices'  => true,
			'is_automatic' => true, // auto activation on installation/updating.
			'dismissable'  => $dismissable,
		] );
	}

	add_action( 'tgmpa_register', 'wpex_tgmpa_register' );
}