<?php
namespace TotalTheme\Forms;

defined( 'ABSPATH' ) || exit;

/**
 * Used for the select wrapper.
 *
 * @package TotalTheme
 * @subpackage Widgets
 * @version 5.6.1
 */
class Select_Wrap {

	/**
	 * Returns select wrap open element.
	 */
	public static function open() {
		echo '<div class="wpex-select-wrap">';
	}

	/**
	 * Returns the custom select arrow.
	 */
	public static function arrow() {
		echo '<div class="wpex-select-arrow">' . self::get_arrow_icon_html() . '</div>';
	}

	/**
	 * Returns arrow theme icon name.
	 */
	public static function get_arrow_ticon() {
		$icon = 'angle-down';

		/**
		 * Filters the select wrap arrow theme icon.
		 *
		 * @param string $icon
		 */
		$icon = (string) apply_filters( 'wpex_select_wrap_arrow_ticon', $icon );

		return $icon;
	}

	/**
	 * Returns select arrow html.
	 */
	public static function get_arrow_icon_html() {
		$html = wpex_get_theme_icon_html( self::get_arrow_ticon(), 'wpex-select-arrow__icon' );

		/**
		 * Filters the select wrap arrow icon html.
		 *
		 * @param string $html
		 */
		$html = (string) apply_filters( 'wpex_select_wrap_arrow_html', $html );

		return $html;
	}

}