<?php
namespace TotalTheme\Footer;

defined( 'ABSPATH' ) || exit;

/**
 * Footer Widgets.
 *
 * @package TotalTheme
 * @subpackage Header
 * @version 5.6.1
 */
class Widgets {

	/**
	 * Are the footer widgets enabled or not.
	 */
	protected static $is_enabled;

	/**
	 * Checks if the footer widgets are enabled or not.
	 */
	public static function is_enabled() {
		if ( ! is_null( self::$is_enabled ) ) {
			return self::$is_enabled;
		}

		if ( wpex_has_custom_footer() || ! empty( $_GET[ 'wpex_inline_footer_template_editor' ] ) ) {
			$check = get_theme_mod( 'footer_builder_footer_widgets', false ); //@todo make the option same value as Customizer?
		} else {
			$check = get_theme_mod( 'footer_widgets', true );
		}

		$post_id = wpex_get_current_post_id();

		if ( $post_id && $meta = get_post_meta( $post_id, 'wpex_disable_footer_widgets', true ) ) {
			if ( 'on' === $meta ) {
				$check = false;
			} elseif ( 'enable' === $meta ) {
				$check = true;
			}
		}

		/**
		 * Filters whether the footer widgets are enabled or not.
		 *
		 * @param bool $check
		 */
		$check = (bool) apply_filters( 'totaltheme/footer/widgets/is_enabled', $check );

		/** deprecated filter **/
		$check = (bool) apply_filters( 'wpex_display_footer_widgets', $check );

		self::$is_enabled = $check;

		return self::$is_enabled;
	}

	/**
	 * Returns footer widgets widget title tag arguments.
	 */
	public static function widget_title_args() {
		$tag_escaped = ( $tag = get_theme_mod( 'footer_headings' ) ) ? tag_escape( $tag ) : 'div';

		return [
			'before' => '<' . $tag_escaped . ' class="widget-title wpex-heading wpex-text-md wpex-mb-20">',
			'after'  => '</' . $tag_escaped . '>',
		];
	}

	/**
	 * Returns wrapper classes.
	 */
	public static function get_wrapper_classes() {
		$columns = (int) get_theme_mod( 'footer_widgets_columns', 4 );
		$gap     = get_theme_mod( 'footer_widgets_gap', '30' );

		$class = [
			'wpex-row',
			'wpex-clr',
		];

		if ( 1 === $columns ) {
			$class[] = 'single-col-footer'; // legacy class.
		}

		if ( $gap ) {
			$class[] = 'gap-' . sanitize_html_class( $gap );
		}

		/**
		 * Filters the footer widget class.
		 *
		 * @param array $class
		 */
		$class = apply_filters( 'totaltheme/footer/widgets/wrapper_class', $class );

		/*** deprecated ***/
		$class = (array) apply_filters( 'wpex_footer_widgets_class', $class );

		return $class;
	}

	/**
	 * Returns the wrapper class.
	 */
	public static function wrapper_class() {
		$classes = self::get_wrapper_classes();

		if ( $classes ) {

			$classes = implode( ' ', $classes );

			/*** deprecated ***/
			$classes = apply_filters( 'wpex_footer_widget_row_classes', $classes );

			echo 'class="' . esc_attr( $classes ) . '"';
		}
	}

}