<?php
namespace TotalTheme\Footer;

use TotalTheme\Header\Core as Header;

defined( 'ABSPATH' ) || exit;

/**
 * Footer.
 *
 * @package TotalTheme
 * @subpackage Header
 * @version 5.6.1
 */
class Core {

	/**
	 * Header is enabled or not.
	 */
	protected static $is_enabled;

	/**
	 * Header is custom, aka using the header builder.
	 */
	protected static $is_custom;

	/**
	 * Checks if the header is enabled or not.
	 */
	public static function is_enabled() {
		if ( ! is_null( self::$is_enabled ) ) {
			return self::$is_enabled;
		}

		$check = true;

		if ( is_page_template( 'templates/landing-page.php' ) ) {
			$check = false;
		}

		$post_id = wpex_get_current_post_id();

		if ( $post_id && $meta = get_post_meta( $post_id, 'wpex_disable_footer', true ) ) {
			if ( 'on' === $meta ) {
				$check = false;
			} elseif ( 'enable' === $meta ) {
				$check = true;
			}
		}

		/**
		 * Filters whether the site has a footer or not.
		 *
		 * @param bool $check
		 * @todo rename filter to wpex_has_footer
		 */
		$check = (bool) apply_filters( 'totaltheme/footer/is_enabled', $check );

		/*** deprecated ***/
		$check = (bool) apply_filters( 'wpex_display_footer', $check );

		self::$is_enabled = $check;

		return self::$is_enabled;
	}

	/**
	 * Checks if the header is custom or not.
	 */
	public static function is_custom() {
		if ( ! is_null( self::$is_custom ) ) {
			return self::$is_custom;
		}

		self::$is_custom = false;

		if ( ! empty( wpex_footer_builder_id() ) ) {
			self::$is_custom = true;
		}

		return self::$is_custom;
	}

	/**
	 * Checks if the footer has reveal on scroll or not.
	 */
	public static function has_reveal() {
		if ( ! self::is_enabled()
			|| 'boxed' === wpex_site_layout()
			|| 'six' === Header::style()
			|| wpex_vc_is_inline()
		) {
			return false;
		}

		$check   = get_theme_mod( 'footer_reveal', false );
		$post_id = wpex_get_current_post_id();

		if ( $post_id && $meta = get_post_meta( $post_id, 'wpex_footer_reveal', true ) ) {
			if ( 'on' === $meta ) {
				$check = true;
			} elseif ( 'off' === $meta ) {
				$check = false;
			}
		}

		/**
		 * Filters whether the footer reveal is enabled.
		 *
		 * @param bool $check
		 */
		$check = (bool) apply_filters( 'totaltheme/footer/has_reveal', $check );

		/*** deprecated ***/
		$check = (bool) apply_filters( 'wpex_has_footer_reveal', $check );

		return $check;
	}

	/**
	 * Returns wrapper classes.
	 */
	public static function get_wrapper_classes() {
		$class = [
			'site-footer',
		];

		if ( get_theme_mod( 'footer_dark_surface', true ) ) {
			$class[] = 'wpex-surface-dark';
		}

		if ( get_theme_mod( 'footer_bg_img' ) && $bg_style = get_theme_mod( 'footer_bg_img_style' ) ) {
			$class[] = 'bg-' . sanitize_html_class( $bg_style );
		}

		/**
		 * Returns the footer wrapper class.
		 *
		 * @param array $class
		 */
		$class = (array) apply_filters( 'totaltheme/footer/wrapper_class', $class );

		/*** deprecated ***/
		$class = (array) apply_filters( 'wpex_footer_class', $class );

		return $class;
	}

	/**
	 * Returns the wrapper class.
	 */
	public static function wrapper_class() {
		$classes = self::get_wrapper_classes();

		if ( $classes ) {
			echo 'class="' . esc_attr( implode( ' ', $classes ) ) . '"';
		}
	}

}