<?php
namespace TotalTheme\Footer\Bottom;

defined( 'ABSPATH' ) || exit;

/**
 * Footer Menu.
 *
 * @package TotalTheme
 * @subpackage Footer\Bottom
 * @version 5.7.0
 */
class Menu {

	/**
	 * Returns theme location for the footer bottom menu.
	 */
	public static function get_theme_location() {
		$location = 'footer_menu';

		/**
		 * Filters the footer bottom menu theme location.
		 *
		 * @param string $location.
		 */
		$location = (string) apply_filters( 'totaltheme/footer/bottom/menu/theme_location', $location );

		/*** deprecated ***/
		$location = (string) apply_filters( 'wpex_footer_menu_location', $location );

		return $location;
	}

	/**
	 * Output wrapper class.
	 */
	public static function wrapper_class() {
		$classes = [
			'wpex-mt-10',
		];

		$align = get_theme_mod( 'bottom_footer_text_align' );

		if ( ! $align || ! in_array( $align, array( 'left', 'center', 'right' ) ) ) {
			$classes[] = 'wpex-md-mt-0';
		}

		/**
		 * Filters the footer bottom menu element class.
		 *
		 * @param array $class
		 */
		$classes = (array) apply_filters( 'totaltheme/footer/bottom/menu/wrapper_class', $classes );

		/*** deprecated ***/
		$classes = (array) apply_filters( 'wpex_footer_bottom_menu_class', $classes );

		if ( $classes ) {
			echo 'class="' . esc_attr( implode( ' ', array_unique( $classes ) ) ) . '"';
		}
	}

}