<?php
namespace TotalTheme\Footer\Bottom;

defined( 'ABSPATH' ) || exit;

/**
 * Footer Bottom.
 *
 * @package TotalTheme
 * @subpackage Header
 * @version 5.7.0
 */
class Core {

	/**
	 * Header is enabled or not.
	 */
	protected static $is_enabled;

	/**
	 * Checks if the header is enabled or not.
	 */
	public static function is_enabled() {
		if ( ! is_null( self::$is_enabled ) ) {
			return self::$is_enabled;
		}

		$post_id = wpex_get_current_post_id();

		if ( wpex_elementor_location_exists( 'footer_bottom' ) ) {
			$check = true;
		} elseif ( wpex_has_custom_footer() || ! empty( $_GET[ 'wpex_inline_footer_template_editor' ] ) ) {
			$check = get_theme_mod( 'footer_builder_footer_bottom', false ); //@todo rename to be same as default.
		} else {
			$check = get_theme_mod( 'footer_bottom', true );
		}

		if ( $post_id ) {
			$meta = get_post_meta( $post_id, 'wpex_footer_bottom', true );
			if ( 'on' === $meta ) {
				$check = true;
			} elseif ( 'off' === $meta ) {
				$check = false;
			}
		}

		/**
		 * Filters whether the footer bottom should display or
		 *
		 * @param bool $check
		 * @param int $post_id
		 */
		$check = (bool) apply_filters( 'totaltheme/footer/bottom/is_enabled', $check, $post_id );

		/*** deprecated ***/
		$check = (bool) apply_filters( 'wpex_has_footer_bottom', $check, $post_id );

		self::$is_enabled = $check;

		return self::$is_enabled;
	}

	/**
	 * Output wrapper class.
	 */
	public static function wrapper_class() {
		$class = [
			'wpex-py-20',
			'wpex-text-sm',
		];

		if ( get_theme_mod( 'footer_bottom_dark_surface', true ) ) {
			$class[] = 'wpex-surface-dark';
			$class[] = 'wpex-bg-gray-900';
		}

		$align = get_theme_mod( 'bottom_footer_text_align' ); // @todo rename to footer_bottom_text_align

		if ( $align && in_array( $align, array( 'left', 'center', 'right' ) ) ) {
			$class[] = 'wpex-text-' . sanitize_html_class( $align );
		} else {
			$class[] = 'wpex-text-center wpex-md-text-left';
		}

		/**
		 * Filters the footer bottom element class.
		 *
		 * @param array $class
		 * @todo rename filter to wpex_footer_bottom_class
		 */
		$class = (array) apply_filters( 'totaltheme/footer/bottom/wrapper_class', $class );

		/*** deprecated ***/
		$class = (array) apply_filters( 'wpex_footer_bottom_classes', $class );

		if ( $class ) {
			echo 'class="' . esc_attr( implode( ' ', $class ) ) . '"';
		}
	}

	/**
	 * Output inner class.
	 */
	public static function inner_class() {
		$class = [
			'container',
		];

		/**
		 * Filters the footer bottom inner element class.
		 *
		 * @param array $class
		 */
		$class = (array) apply_filters( 'totaltheme/footer/bottom/inner_class', $class );

		/*** deprecated ***/
		$class = (array) apply_filters( 'wpex_footer_bottom_inner_class', $class );

		if ( $class ) {
			echo 'class="' . esc_attr( implode( ' ', $class ) ) . '"';
		}
	}

}