<?php
namespace TotalTheme\Footer\Bottom;

defined( 'ABSPATH' ) || exit;

/**
 * Footer Copyright.
 *
 * @package TotalTheme
 * @subpackage Footer\Bottom
 * @version 5.7.0
 */
class Copyright {

	/**
	 * Return default content.
	 */
	public static function get_default_content() {
		return 'Copyright <a href="[site_url]">[site_name]</a> [current_year] - All Rights Reserved';
	}

	/**
	 * Return copyright content.
	 */
	public static function get_content() {
		$content = wpex_get_translated_theme_mod( 'footer_copyright_text', self::get_default_content() );

		/**
		 * Filters the footer bottom copyright content.
		 *
		 * @param $content
		 */
		$content = (string) apply_filters( 'totaltheme/footer/bottom/copyright/content', $content );

		return $content;
	}

}