<?php
defined( 'ABSPATH' ) || exit;

$this->sections['wpex_menu_search'] = array(
	'title' => esc_html__( 'Menu Search', 'total' ),
	'panel' => 'wpex_header',
	'settings' => array(
		array(
			'id' => 'menu_search_enable',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Menu Search', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'menu_search_style',
			'default' => 'drop_down',
			'control' => array(
				'label' => esc_html__( 'Style', 'total' ),
				'type' => 'select',
				'choices' => array(
					'drop_down' => esc_html__( 'Drop Down','total' ),
					'overlay' => esc_html__( 'Site Overlay','total' ),
					'header_replace' => esc_html__( 'Header Replace','total' )
				),
				'description' => esc_html__( 'The vertical header may not support all styles.', 'total' ),
			),
		),
		array(
			'id' => 'menu_search_icon',
			'default' => 'search',
			'control' => array(
				'label' => esc_html__( 'Icon', 'total' ),
				'type' => 'wpex_ticon_select',
				'choices' => TotalTheme\Header\Menu\Search::icon_choices(),
			),
		),
		array(
			'id' => 'menu_search_icon_size',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Icon Size', 'total' ),
				'type' => 'wpex_length_unit',
			),
			'inline_css' => [
				'target' => '.wpex-menu-search-icon,.wpex-header-search-icon__icon',
				'alter' => 'font-size',
			],
		),
		array(
			'id' => 'menu_search_placeholder',
			'control' => array(
				'label' => esc_html__( 'Placeholder Text', 'total' ),
				'type' => 'text',
			),
		),
		array(
			'id' => 'search_dropdown_top_border',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Drop Down Top Border', 'total' ),
				'type' => 'color',
			),
			'inline_css' => array(
				'target' => '#searchform-dropdown',
				'alter' => '--wpex-dropmenu-colored-top-border-color',
			),
		),
		array(
			'id' => 'search_overlay_background',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Overlay Background', 'total' ),
				'type' => 'color',
			),
			'inline_css' => array(
				'target' => '#wpex-searchform-overlay',
				'alter' => 'background-color',
			),
		),
	)
);