<?php
defined( 'ABSPATH' ) || exit;

$this->sections['wpex_header_megamenus'] = array(
	'title' => esc_html__( 'Megamenus', 'total' ),
	'panel' => 'wpex_header',
	'settings' => array(
		array(
			'id' => 'megamenu_stretch',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Full-width', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'This will place your megamenus at the bottom of the header and stretch them to the same width as your header. If disabled the megamenus will display like the other menus right under the link and only as wide as the menu itself.', 'total' ),
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => array( 'one', 'seven', 'eight', 'nine', 'ten' ),
			),
		),
		array(
			'id' => 'megamenu_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'label' => esc_html__( 'Outer Padding', 'total' ),
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => '--wpex-megamenu-padding',
				'sanitize' => 'fallback_px',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'megamenu_gutter',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'units' => array( 'px' ),
				'label' => esc_html__( 'Gutter', 'total' ),
				'placeholder' => '24',
				'description' => esc_html__( 'Spacing between columns.', 'total' ),
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => '--wpex-megamenu-gutter',
				'sanitize' => 'px',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'megamenu_heading_font_size',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'label' => esc_html__( 'Heading Font Size', 'total' ),
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => '--wpex-megamenu-heading-font-size',
				'sanitize' => 'font_size',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'megamenu_heading_margin_bottom',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'placeholder' => '0',
				'label' => esc_html__( 'Heading Margin Bottom', 'total' ),
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => '--wpex-megamenu-heading-margin-bottom',
				'sanitize' => 'fallback_px',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'megamenu_heading_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Heading Color', 'total' ),
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => '--wpex-megamenu-heading-color',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'megamenu_heading_font_weight',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'select',
				'label' => esc_html__( 'Heading Font Weight', 'total' ),
				'choices' => 'font_weight',
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => '--wpex-megamenu-heading-font-weight',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'megamenu_divider_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Divider Color', 'total' ),
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => '--wpex-megamenu-divider-color',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'megamenu_link_padding_y',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'exclude_units' => array( '%' ),
				'label' => esc_html__( 'Link Vertical Padding', 'total' ),
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap .megamenu',
				'alter' => '--wpex-dropmenu-link-padding-y',
				'sanitize' => 'fallback_px',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'megamenu_link_padding_x',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'exclude_units' => array( '%' ),
				'label' => esc_html__( 'Link Horizontal Padding', 'total' ),
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap .megamenu',
				'alter' => '--wpex-dropmenu-link-padding-x',
				'sanitize' => 'fallback_px',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
	),
);