<?php
defined( 'ABSPATH' ) || exit;

$this->sections['wpex_header_general'] = array(
	'title' => esc_html__( 'General', 'total' ),
	'panel' => 'wpex_header',
	'settings' => array(
		array(
			'id' => 'enable_header',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Site Header', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'full_width_header',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Full Width', 'total' ),
				'type' => 'wpex_toggle',
			),
			'control_display' => array(
				'check' => 'main_layout_style',
				'value' => 'full-width',
			),
		),
		array(
			'id' => 'header_style',
			'default' => 'one',
			'control' => array(
				'label' => esc_html__( 'Style', 'total' ),
				'type' => 'select',
				'choices' => 'header_style',
				'description' => esc_html__( 'Consider using one of the newer modern "Flex" header styles.', 'total' ),
			),
		),
		array(
			'id' => 'header_height',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Height', 'total' ),
				'description' => esc_html__( 'The Flex header styles must have a fixed height.', 'total' ),
				'type' => 'wpex_length_unit',
				'units' => array( 'px', 'vw', 'vh', 'vmin', 'vmax', 'func' ),
				'placeholder' => '100',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-site-header-height',
				'sanitize' => 'fallback_px',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => array( 'seven', 'eight', 'nine', 'ten' ),
			),
		),
		array(
			'id' => 'header_gutter',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Gutter', 'total' ),
				'description' => esc_html__( 'Adds spacing between your header elements. For the centered menu header style the gutter is applied below mobile menu breakpoint only.', 'total' ),
				'type' => 'wpex_length_unit',
				'placeholder' => '25',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-site-header-gutter',
				'sanitize' => 'margin',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => array( 'seven', 'eight', 'nine', 'ten' ),
			),
		),
		array(
			'id' => 'vertical_header_style',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Vertical Header Style', 'total' ),
				'type' => 'select',
				'choices' => array(
					'' => esc_html__( 'Default', 'total' ),
					'fixed' => esc_html__( 'Fixed', 'total' ),
				),
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'six',
			),
		),
		array(
			'id' => 'vertical_header_position',
			'default' => 'left',
			'control' => array(
				'label' => esc_html__( 'Vertical Header Position', 'total' ),
				'type' => 'select',
				'choices' => array(
					'left' => esc_html__( 'Left', 'total' ),
					'right' => esc_html__( 'Right', 'total' ),
				),
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'six',
			),
		),
		array(
			'id' => 'vertical_header_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Vertical Header Width', 'total' ),
				'type' => 'wpex_pixel',
				'input_attrs' => array(
					'placeholder' => '280',
				),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-vertical-header-width',
				'sanitize' => 'px',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'six',
			),
		),
		array(
			'id' => 'header_top_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'label' => esc_html__( 'Top Padding', 'total' ),
				'placeholder' => '30',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => array( 'seven', 'eight', 'nine', 'ten' ),
				'compare' => 'not_equal',
			),
			'inline_css' => array(
				'target' => '.header-padding',
				'alter' => 'padding-top',
				'sanitize' => 'padding',
			),
		),
		array(
			'id' => 'header_bottom_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'label' => esc_html__( 'Bottom Padding', 'total' ),
				'placeholder' => '30',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => array( 'seven', 'eight', 'nine', 'ten' ),
				'compare' => 'not_equal',
			),
			'inline_css' => array(
				'target' => '.header-padding',
				'alter' => 'padding-bottom',
				'sanitize' => 'padding',
			),
		),
		array(
			'id' => 'header_color',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Color', 'total' ),
				'type' => 'color',
				'description' => esc_html__( 'The color option will target elements inside the header such as those located in the aside area, the mobile menu hamburger icon or custom content added via hooks. It will not target the logo or menu.', 'total' ),
			),
			'inline_css' => array(
				'target' => '#site-header,#searchform-header-replace',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'header_background',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Background', 'total' ),
				'type' => 'color',
			),
			'inline_css' => array(
				// @todo can we target a CSS var instead?
				'target' => array(
					'#site-header',
					'#site-header-sticky-wrapper',
					'#site-header-sticky-wrapper.is-sticky #site-header',
					'.boxed-main-layout #site-header-sticky-wrapper.is-sticky #site-header',
					'.footer-has-reveal #site-header',
					'#searchform-header-replace',
					'.wpex-has-vertical-header #site-header',
				),
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'header_background_image',
			'control' => array(
				'type' => 'media',
				'mime_type' => 'image',
				'label' => esc_html__( 'Background Image', 'total' ),
			),
		),
		array(
			'id' => 'header_background_image_style',
			'control' => array(
				'label' => esc_html__( 'Background Image Style', 'total' ),
				'type'  => 'select',
				'choices' => 'bg_style',
			),
		),
		/*** Flex Header Aside ***/
		array(
			'id' => 'header_flex_aside_heading',
			'control' => array(
				'type' => 'wpex-heading',
				'label' => esc_html__( 'Aside', 'total' ),
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => array( 'seven', 'eight', 'nine', 'ten' ),
			),
		),
		array(
			'id' => 'header_flex_aside_visibility',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Visibility', 'total' ),
				'type' => 'wpex-visibility-select',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => array( 'seven', 'eight', 'nine', 'ten' ),
			),
		),
		array(
			'id' => 'header_flex_aside_content',
			'transport' => 'partialRefresh',
			'control' => array(
				'label' => esc_html__( 'Side Content', 'total' ),
				'type' => 'wpex_textarea',
				'description' => esc_html__( 'HTML and shortcodes allowed.', 'total' ),
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => array( 'seven', 'eight', 'nine', 'ten' ),
			),
		),
		array(
			'id' => 'header_flex_aside_link_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color', 'total' ),
			),
			'inline_css' => array(
				'target' => '#site-header-flex-aside',
				'alter' => array(
					'--wpex-link-color',
					'--wpex-hover-link-color',
				),
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => array( 'seven', 'eight', 'nine', 'ten' ),
			),
		),
		array(
			'id' => 'header_flex_aside_link_hover_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color: Hover', 'total' ),
			),
			'inline_css' => array(
				'target' => '#site-header-flex-aside',
				'alter' => array(
					'--wpex-hover-link-color',
				),
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => array( 'seven', 'eight', 'nine', 'ten' ),
			),
		),
		/*** Aside ***/
		array(
			'id' => 'header_aside_heading',
			'control' => array(
				'type' => 'wpex-heading',
				'label' => esc_html__( 'Aside', 'total' ),
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'header_has_aside',
			),
		),
		array(
			'id' => 'header_flex_items',
			'control' => array(
				'label' => esc_html__( 'Vertical Align Aside Content', 'total' ),
				'type' => 'wpex_toggle',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'two',
			),
		),
		array(
			'id' => 'header_aside_search',
			'transport' => 'partialRefresh',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Header Aside Search', 'total' ),
				'type' => 'wpex_toggle',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'two',
			),
		),
		array(
			'id' => 'header_aside_visibility',
			'transport' => 'postMessage',
			'default' => 'hide-at-mm-breakpoint',
			'control' => array(
				'label' => esc_html__( 'Visibility', 'total' ),
				'type' => 'wpex-visibility-select',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'header_has_aside',
			),
		),
		array(
			'id' => 'header_aside',
			'transport' => 'partialRefresh',
			'control' => array(
				'label' => esc_html__( 'Header Aside Content', 'total' ),
				'type' => 'textarea',
				'description' => esc_html__( 'HTML and shortcodes allowed.', 'total' ),
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'header_has_aside',
			),
		),
	)
);