<?php
defined( 'ABSPATH' ) || exit;

$this->sections['wpex_buttons'] = array(
	'title' => esc_html__( 'Buttons', 'total' ),
	'panel' => 'wpex_global_styles',
	'settings' => array(
		array(
			'id' => 'theme_button_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_trbl',
				'shorthand' => true,
				'label' => esc_html__( 'Padding', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-btn-padding',
			),
		),
		array(
			'id' => 'theme_button_border_radius',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'units' => array( 'px', 'em', 'rem', '%', 'var' ),
				'label' => esc_html__( 'Border Radius', 'total' ),
				'placeholder' => '3',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-btn-border-radius',
			),
		),
		array(
			'id' => 'theme_button_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-btn-color',
			),
		),
		array(
			'id' => 'theme_button_hover_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color: Hover', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-hover-btn-color',
			),
		),
		array(
			'id' => 'theme_button_active_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color: Active', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-active-btn-color',
			),
		),
		array(
			'id' => 'theme_button_bg',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-btn-bg',
			),
		),
		array(
			'id' => 'theme_button_hover_bg',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background: Hover', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-hover-btn-bg',
			),
		),
		array(
			'id' => 'theme_button_active_bg',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background: Active', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-active-btn-bg',
			),
		),
		array(
			'id' => 'theme_button_border_style',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'select',
				'label' => esc_html__( 'Border Style', 'total' ),
				'choices' => array(
					'' => esc_html__( 'None', 'total' ),
					'solid' => esc_html__( 'Solid', 'total' ),
					'dashed' => esc_html__( 'Dashed', 'total' ),
					'none' => esc_html__( 'None', 'total' ),
				),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-btn-border-style',
			),
		),
		array(
			'id' => 'theme_button_border_width',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'units' => array( 'px' ),
				'label' => esc_html__( 'Border Width', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-btn-border-width',
				'sanitize' => 'px',
			),
		),
		array(
			'id' => 'theme_button_border_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Border', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-btn-border-color',
			),
		),
		array(
			'id' => 'theme_button_hover_border_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Border: Hover', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-hover-btn-border-color',
			),
		),
		array(
			'id' => 'theme_button_active_border_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Border: Active', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-active-btn-border-color',
			),
		),
	),
);