<?php
defined( 'ABSPATH' ) || exit;

// Don't show settings when using the footer builder, unless enabled.
if ( get_theme_mod( 'footer_builder_enable', true ) && wpex_has_custom_footer() ) {
	$footer_builder_has_widgets = get_theme_mod( 'footer_builder_footer_widgets', false );
	if ( ! $footer_builder_has_widgets ) {
		return;
	}
}

$this->sections['wpex_footer_widgets'] = array(
	'title' => esc_html__( 'General', 'total' ),
	'settings' => array(
		// General
		array(
			'id' => 'footer_widgets',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Footer Widgets', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'footer_dark_surface',
			'transport' => 'postMessage',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Dark Surface', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'Adds dark styling to the element, disable to use default color scheme.', 'total' ),
			),
		),
		array(
			'id' => 'fixed_footer',
			'default' => false,
			'control' => array(
				'label' => esc_html__( 'Fixed Footer', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'Adds a min-height to your #main container to keep your footer widgets at the bottom of the browser window.', 'total' ),
			),
		),
		array(
			'id' => 'footer_reveal',
			'default' => false,
			'control' => array(
				'label' => esc_html__( 'Footer Reveal', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'The footer widgets will be placed in a fixed postion and display on scroll. This setting is for the "Full-Width" layout and desktops only.', 'total' ),
			),
		),
		array(
			'id' => 'footer_link_underline',
			'default' => false,
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_toggle',
				'label' => esc_html__( 'Underline Links', 'total' ),
				'description' => esc_html__( 'Applies to "standard" links only.', 'total' ),
			),
			'inline_css' => array(
				'target' => '#footer',
				'alter' => array(
					'--wpex-link-text-decoration',
					'--wpex-hover-link-text-decoration',
				),
				'value' => 'underline',
			),
		),
		array(
			'id' => 'footer_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_trbl',
				'label' => esc_html__( 'Padding', 'total' ),
			),
			'inline_css' => array(
				'target' => '#footer-inner',
				'alter' => 'padding',
			),
		),
		array(
			'id' => 'footer_background',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background Color', 'total' ),
			),
			'inline_css' => array(
				'target' => '#footer',
				'alter' => array(
					'--wpex-surface-1',
					'background-color',
				),
			),
		),
		array(
			'id' => 'footer_bg_img',
			'control' => array(
				'type' => 'media',
				'mime_type' => 'image',
				'label' => esc_html__( 'Background Image', 'total' ),
			),
		),
		array(
			'id' => 'footer_bg_img_style',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Background Image Style', 'total' ),
				'type'  => 'select',
				'choices' => 'bg_style',
			),
			'control_display' => array(
				'check' => 'footer_bg_img',
				'value' => 'true',
			),
		),
		array(
			'id' => 'footer_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Text Color', 'total' ),
			),
			'inline_css' => array(
				'target' => '#footer',
				'alter' => array(
					'color',
					'--wpex-heading-color', // this is fallback as this option has always changed the heading color.
					'--wpex-text-2',
				),
			),
		),
		array(
			'id' => 'footer_borders',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Borders Color', 'total' ),
			),
			'inline_css' => array(
				'target' => '#footer',
				'alter' => '--wpex-border-main', // don't target tables incase they use light mode footer.
			),
		),
		array(
			'id' => 'footer_heading_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Headings', 'total' ),
				'description' => esc_html__( 'Applies to headings (h2, h3, h4, h5) inside widgets.', 'total' ),
			),
			'inline_css' => array(
				'target' => '#footer',
				'alter' => '--wpex-heading-color',
			),
		),
		array(
			'id' => 'footer_link_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Links', 'total' ),
			),
			'inline_css' => array(
				'target' => '#footer',
				'alter' => array(
					'--wpex-link-color',
					'--wpex-hover-link-color', // !!important!!
				),
			),
		),
		array(
			'id' => 'footer_link_color_hover',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Links: Hover', 'total' ),
			),
			'inline_css' => array(
				'target' => '#footer',
				'alter' => '--wpex-hover-link-color',
			),
		),

		// Widget Titles
		array(
			'id' => 'footer_widgets_titles_heading',
			'control' => array(
				'type' => 'wpex-heading',
				'label' => esc_html__( 'Widget Titles', 'total' ),
			),
		),
		array(
			'id' => 'footer_headings',
			'transport' => 'postMessage',
			'default' => 'div',
			'control' => array(
				'label' => esc_html__( 'Tag', 'total' ),
				'type' => 'select',
				'choices' => array(
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
					'span' => 'span',
					'div' => 'div',
				),
			),
		),
		array(
			'id' => 'footer_headings_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'total' ),
			),
			'inline_css' => array(
				'target' => '.footer-widget .widget-title',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'footer_headings_background',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background', 'total' ),
			),
			'inline_css' => array(
				'target' => '.footer-widget .widget-title',
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'footer_headings_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_trbl',
				'label' => esc_html__( 'Padding', 'total' ),
			),
			'inline_css' => array(
				'target' => '.footer-widget .widget-title',
				'alter' => 'padding',
			),
		),
		array(
			'id' => 'footer_headings_align',
			'transport' => 'postMessage',
			'control' =>  array(
				'type' => 'select',
				'label' => esc_html__( 'Text Align', 'total' ),
				'choices' => array(
					'' => esc_html__( 'Default','total' ),
					'left' => esc_html__( 'Left','total' ),
					'right' => esc_html__( 'Right','total' ),
					'center' => esc_html__( 'Center','total' ),
				),
			),
			'inline_css' => array(
				'target' => '.footer-widget .widget-title',
				'alter' => 'text-align',
			),
		),

		// Widget columns
		array(
			'id' => 'footer_widgets_col_heading',
			'control' => array(
				'type' => 'wpex-heading',
				'label' => esc_html__( 'Columns', 'total' ),
			),
		),
		array(
			'id' => 'footer_widgets_columns',
			'default' => '4',
			'control' => array(
				'label' => esc_html__( 'Columns', 'total' ),
				'type' => 'select',
				'choices' => array(
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
				),
			),
		),
		array(
			'id' => 'footer_widgets_gap',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Gap', 'total' ),
				'type' => 'select',
				'choices' => 'column_gap',
			),
		),
		array(
			'id' => 'footer_widgets_bottom_margin',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Bottom Margin', 'total' ),
				'type' => 'wpex_length_unit',
				'description' => esc_html__( 'The Bottom Margin is technically applied to each widget so you have space between widgets added in the same column. If you alter this value you should probably also change your general Footer top padding so the top/bottom spacing in your footer area match.', 'total' ),
			),
			'inline_css' => array(
				'target' => '.footer-widget',
				'alter' => 'padding-bottom',
				'sanitize' => 'fallback_px',
			),
		),
		array(
			'id' => 'footer_widgets_col_1_width',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'units' => array( 'px', '%', 'func' ),
				'label' => esc_html__( 'Column 1 Width', 'total' ),
			),
			'inline_css' => array(
				'target' => '.footer-box.col-1',
				'alter' => 'width',
				'sanitize' => 'fallback_px',
			),
		),
		array(
			'id' => 'footer_widgets_col_2_width',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'units' => array( 'px', '%', 'func' ),
				'label' => esc_html__( 'Column 2 Width', 'total' ),
			),
			'inline_css' => array(
				'target' => '.footer-box.col-2',
				'alter' => 'width',
				'sanitize' => 'fallback_px',
			),
		),
		array(
			'id' => 'footer_widgets_col_3_width',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'units' => array( 'px', '%', 'func' ),
				'label' => esc_html__( 'Column 3 Width', 'total' ),
			),
			'inline_css' => array(
				'target' => '.footer-box.col-3',
				'alter' => 'width',
				'sanitize' => 'fallback_px',
			),
		),
		array(
			'id' => 'footer_widgets_col_4_width',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'units' => array( 'px', '%', 'func' ),
				'label' => esc_html__( 'Column 4 Width', 'total' ),
			),
			'inline_css' => array(
				'target' => '.footer-box.col-4',
				'alter' => 'width',
				'sanitize' => 'fallback_px',
			),
		),
		array(
			'id' => 'footer_widgets_col_5_width',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'units' => array( 'px', '%', 'func' ),
				'label' => esc_html__( 'Column 5 Width', 'total' ),
			),
			'inline_css' => array(
				'target' => '.footer-box.col-5',
				'alter' => 'width',
				'sanitize' => 'fallback_px',
			),
		),
		array(
			'id' => 'footer_widgets_col_6_width',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'units' => array( 'px', '%', 'func' ),
				'label' => esc_html__( 'Column 6 Width', 'total' ),
			),
			'inline_css' => array(
				'target' => '.footer-box.col-6',
				'alter' => 'width',
				'sanitize' => 'fallback_px',
			),
		),
	),
);