<?php
defined( 'ABSPATH' ) || exit;

// General
$this->sections['wpex_footer_bottom'] = array(
	'title' => esc_html__( 'General', 'total' ),
	'settings' => array(
		array(
			'id' => 'footer_bottom',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Footer Bottom', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'footer_bottom_dark_surface',
			'transport' => 'postMessage',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Dark Surface', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'Adds dark styling to the element, disable to use default color scheme.', 'total' ),
			),
		),
		array(
			'id' => 'bottom_footer_link_underline',
			'default' => false,
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_toggle',
				'label' => esc_html__( 'Underline Links', 'total' ),
				'description' => esc_html__( 'Applies to both the copyright and the menu.', 'total' ),
			),
			'inline_css' => array(
				'target' => '#footer-bottom',
				'alter' => array(
					'--wpex-link-text-decoration',
					'--wpex-hover-link-text-decoration',
				),
				'value' => 'underline',
			),
		),
		array(
			'id' => 'footer_copyright_text',
			'transport' => 'partialRefresh',
			'default' => TotalTheme\Footer\Bottom\Copyright::get_default_content(),
			'control' => array(
				'label' => esc_html__( 'Copyright', 'total' ),
				'type' => 'wpex_textarea',
			),
		),
		array(
			'id' => 'bottom_footer_text_align',
			'transport' => 'partialRefresh',
			'control' =>  array(
				'type' => 'select',
				'label' => esc_html__( 'Text Align', 'total' ),
				'choices' => array(
					'' => esc_html__( 'Default','total' ),
					'left' => esc_html__( 'Left','total' ),
					'right' => esc_html__( 'Right','total' ),
					'center' => esc_html__( 'Center','total' ),
				),
			),
		),
		array(
			'id' => 'bottom_footer_padding',
			'transport' => 'postMessage',
			'control' =>  array(
				'type' => 'wpex_trbl',
				'label' => esc_html__( 'Padding', 'total' ),
			),
			'inline_css' => array(
				'target' => '#footer-bottom',
				'alter' => 'padding',
			),
		),
		array(
			'id' => 'bottom_footer_background',
			'transport' => 'postMessage',
			'control' =>  array(
				'type' => 'color',
				'label' => esc_html__( 'Background', 'total' ),
			),
			'inline_css' => array(
				'target' => '#footer-bottom',
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'bottom_footer_color',
			'transport' => 'postMessage',
			'control' =>  array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'total' ),
			),
			'inline_css' => array(
				'target' => '#footer-bottom',
				'alter' => array(
					'color',
					'--wpex-text-2'
				),
			),
		),
		array(
			'id' => 'bottom_footer_link_color',
			'transport' => 'postMessage',
			'control' =>  array(
				'type' => 'color',
				'label' => esc_html__( 'Links', 'total' ),
			),
			'inline_css' => array(
				'target' => '#footer-bottom',
				'alter' => array(
					'--wpex-link-color',
					'--wpex-hover-link-color',
				),
			),
		),
		array(
			'id' => 'bottom_footer_link_color_hover',
			'transport' => 'postMessage',
			'control' =>  array(
				'type' => 'color',
				'label' => esc_html__( 'Links: Hover', 'total' ),
			),
			'inline_css' => array(
				'target' => '#footer-bottom',
				'alter' => '--wpex-hover-link-color',
			),
		),
	),
);