<?php
namespace TotalTheme\Customizer\Controls;

use \WP_Customize_Control;
use \TotalTheme\Topbar\Social as Topbar_Social;

/**
 * Customizer Social_Profiles Control
 *
 * @package TotalTheme
 * @subpackage Customizer
 * @version 5.5.6
 */
class Social_Profiles extends WP_Customize_Control {

	/**
	 * The control type.
	 */
	public $type = 'wpex_social_profiles';

	/**
	 * Enque scripts.
	 */
	public function enqueue() {
		wp_enqueue_script( 'jquery-ui-core' );
		wp_enqueue_script( 'jquery-ui-sortable' );
	}

	/**
	 * Render Control Content.
	 */
	public function render_content() {
		$input_id       = '_customize-input-' . $this->id;
		$description_id = '_customize-description-' . $this->id;
		$value          = $this->value();
		$social_options = (array) Topbar_Social::get_profile_options();

		if ( ! is_array( $value ) ) {
			$value = json_decode( $value, true );
		}

		?>

		<?php if ( ! empty( $this->label ) ) : ?>
			<label for="<?php echo esc_attr( $input_id ); ?>" class="customize-control-title"><?php echo esc_html( $this->label ); ?></label>
		<?php endif; ?>

		<?php if ( ! empty( $this->description ) ) : ?>
			<span id="<?php echo esc_attr( $description_id ); ?>" class="description customize-control-description"><?php echo esc_html( $this->description ); ?></span>
		<?php endif; ?>

		<div class="wpex-customize-social-profiles">

			<div class="wpex-customize-social-profiles__list">
				<?php if ( $value && is_array( $value ) ) {
					foreach ( $value as $site => $url ) {
						if ( ! $url || ! array_key_exists( $site, $social_options ) ) {
							continue;
						}
						echo '<div class="wpex-customize-social-profiles__item">';
							echo '<label>' . esc_html( $social_options[$site]['label'] ) . '</label>';
							echo '<div>';
								echo '<input value="' . esc_attr( $url ) . '" type="text" data-wpex-key="' . esc_attr( $site ) . '">';
								echo '<button class="wpex-customize-social-profiles__delete-item button-secondary"><span class="dashicons dashicons-trash"></span></button>';
							echo '</div>';
						echo '</div>';
					}
				} ?>
			</div>

			<hr>

			<?php
			// Template
			echo '<div class="wpex-customize-social-profiles__template">';
				echo '<label></label>';
				echo '<div>';
					echo '<input type="text" value="" data-wpex-key="">';
					echo '<button class="wpex-customize-social-profiles__delete-item button-secondary"><span class="dashicons dashicons-trash"></span></button>';
				echo '</div>';
			echo '</div>';

			// Select
			echo '<select class="wpex-customize-social-profiles__select">';
				echo '<option>' . esc_html__( 'Select a site', 'total' ) . '</option>';
				foreach ( $social_options as $key => $args ) {
					echo '<option value="' . esc_attr( $key ) . '">' . esc_html( $args['label'] ) . '</option>';
				}
			echo '</select>';

			// Add new button.
			echo '<button type="button" class="wpex-customize-social-profiles__add-item button button-primary">+ ' . esc_html__( 'Add New', 'total' ) . '</button>';

			?>

		</div>

	<?php }

}