<?php
namespace TotalTheme\Customizer\Controls;

use \WP_Customize_Control;

defined( 'ABSPATH' ) || exit;

/**
 * Customizer Multi-Check Control.
 *
 * @package TotalTheme
 * @subpackage Customizer
 * @version 5.4.5
 */
class Multiple_Select extends WP_Customize_Control {

	/**
	 * The control description.
	 */
	public $description = '';

	/**
	 * The control subtitle.
	 */
	public $subtitle = '';

	/**
	 * The control type.
	 */
	public $type = 'wpex_multi_select';

	/**
	 * The control template.
	 */
	public function render_content() {
		if ( is_array( $this->value() ) ) {
			$value_csv = implode( ',', $this->value() );
			$values = $this->value();
		} else {
			$value_csv = $this->value();
			$values = explode( ',', $this->value() );
		}

		?>

		<label class="wpex-customize-multi-select">

			<?php if ( ! empty( $this->label ) ) : ?>
				<label><span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span></label>
			<?php endif; ?>

			<?php if ( ! empty( $this->description ) ) : ?>
				<span class="description customize-control-description"><?php
					echo wp_strip_all_tags( $this->description );
				?></span>
			<?php endif; ?>

			<?php if ( ! empty( $this->subtitle ) ) : ?>
				<div class="customizer-subtitle"><?php echo esc_html( $this->subtitle ); ?></div>
			<?php endif; ?>

			<?php foreach ( $this->choices as $value => $label ) {
				printf( '<label for="%s"><input class="wpex-customize-multi-select__input" id="%s" type="checkbox" value="%s" %s> %s</label><br>',
					esc_attr( $this->id . $value ),
					esc_attr( $this->id . $value ),
					esc_attr( $value ),
					checked( in_array( $value, $values ), true, false ),
					esc_html( $label )
				);
			} ?>
		</label>

		<?php
	}
}