<?php
namespace TotalTheme\Customizer\Controls;

use \WP_Customize_Control;

/**
 * Customizer Pixel Control
 *
 * @package TotalTheme
 * @subpackage Customizer
 * @version 5.4.5
 */
class Length_Unit extends WP_Customize_Control {

	/**
	 * The control type.
	 */
	public $type = 'wpex_length_unit';

	/**
	 * Units to select from.
	 */
	public $units = array();

	/**
	 * Excluded units
	 */
	public $exclude_units = array();

	/**
	 * Default unit.
	 */
	public $default_unit = null;

	/**
	 * Placeholder Text.
	 */
	public $placeholder = '';

	/**
	 * Allow numeric.
	 */
	public $allow_numeric = true;

	/**
	 * Render Control Content.
	 */
	public function render_content() {
		$input_id       = '_customize-input-' . $this->id;
		$units          = $this->get_units();
		$default_unit   = $this->get_default_unit();
		$value          = trim( $this->value() );
		$value_numeric  = $value ? floatval( $value ) : '';
		$input_type     = $this->get_input_type( $value );

		if ( 0 === $value || '0' === $value ) {
			$value = '';
		}

		if ( ! $this->allow_numeric && is_numeric( $value ) ) {
			$value = $value_numeric = '';
			$input_type = 'std';
		}

		switch ( $input_type ) {
			case 'num':
				$current_unit = 'num';
				break;
			case 'var':
				$current_unit = 'var';
				break;
			case 'clamp':
				$current_unit = 'clamp';
				break;
			case 'calc':
				$current_unit = 'calc';
				break;
			case 'func':
				$current_unit = 'func';
				break;
			default:
				$current_unit = $this->get_unit( $value ) ?: $default_unit;
				break;
		}

		if ( ! in_array( $current_unit, $units ) && in_array( 'func', $units ) ) {
			$input_type   = 'func';
			$current_unit = 'func';
		}

		?>

		<?php if ( ! empty( $this->label ) ) : ?>
			<label class="customize-control-title"><?php echo esc_html( $this->label ); ?></label>
		<?php endif; ?>

		<?php if ( ! empty( $this->description ) ) : ?>
			<span id="_customize-description-<?php echo esc_attr( $this->id ); ?>" class="description customize-control-description"><?php echo esc_html( $this->description ); ?></span>
		<?php endif; ?>

		<div class="wpex-customize-length-unit wpex-customize-length-unit--<?php echo esc_attr( $input_type ); ?>">
			<?php if ( 'var' === $input_type ) {
				$var_value = str_replace( 'var(', '', $value );
				$var_value = rtrim( $var_value, ')' );
				?>
				<input type="text" class="wpex-customize-length-unit__input" value="<?php echo esc_attr( $var_value ); ?>" placeholder="<?php echo esc_attr( $this->placeholder ); ?>" data-placeholder="<?php echo esc_attr( $this->placeholder ); ?>">
			<?php } elseif ( 'calc' === $input_type ) {
				$var_value = str_replace( 'calc(', '', $value );
				$var_value = rtrim( $var_value, ')' );
				?>
				<input type="text" class="wpex-customize-length-unit__input" value="<?php echo esc_attr( $var_value ); ?>" placeholder="<?php echo esc_attr( $this->placeholder ); ?>" data-placeholder="<?php echo esc_attr( $this->placeholder ); ?>">
			<?php } elseif ( 'clamp' === $input_type ) {
				$var_value = str_replace( 'clamp(', '', $value );
				$var_value = rtrim( $var_value, ')' );
				?>
				<input type="text" class="wpex-customize-length-unit__input" value="<?php echo esc_attr( $var_value ); ?>" placeholder="<?php echo esc_attr( $this->placeholder ); ?>" data-placeholder="<?php echo esc_attr( $this->placeholder ); ?>">
			<?php } elseif ( 'func' === $input_type ) { ?>
				<input type="text" class="wpex-customize-length-unit__input" value="<?php echo esc_attr( $value ); ?>" placeholder="<?php echo esc_attr( $this->placeholder ); ?>" data-placeholder="<?php echo esc_attr( $this->placeholder ); ?>">
			<?php } else { ?>
				<input type="number" class="wpex-customize-length-unit__input" inputmode="numeric" value="<?php echo esc_attr( $value_numeric ); ?>" placeholder="<?php echo esc_attr( $this->placeholder ); ?>" data-placeholder="<?php echo esc_attr( $this->placeholder ); ?>">
			<?php } ?>
			<span class="wpex-customize-length-unit__select-wrap">
				<select class="wpex-customize-length-unit__select"><?php
					if ( $this->default_unit ) {
						array_unshift( $units, $this->default_unit );
						$units = array_unique( $units );
					}

					foreach ( $units as $unit ) {
						echo '<option value="' . esc_attr( $unit ) . '" ' . selected( $unit, $current_unit, false )  . '>' . esc_html( strtoupper( $unit ) ) . '</option>';
					}
				?></select>
			</span>
			<input type="hidden" id="<?php echo esc_attr( $input_id ); ?>" value="<?php echo esc_attr( $value ); ?>" <?php $this->link(); ?>>
		</div>

		<?php
	}

	/**
	 * Return default units.
	 */
	protected function get_default_units() {
		return array(
			'px',
			'em',
			'rem',
			'vw',
			'vh',
			'vmin',
			'vmax',
			'%',
			'var',
		//	'calc',
		//	'clamp',
			'func',
		);
	}

	/**
	 * Returns the units we can choose from.
	 */
	protected function get_units() {
		if ( ! $this->units ) {
			$this->units = $this->get_default_units();
		}
		if ( $this->exclude_units ) {
			$this->units = array_diff( $this->units, $this->exclude_units );
		}
		return $this->units;
	}

	/**
	 * Returns the default unit.
	 */
	protected function get_default_unit() {
		$units = $this->get_units();
		if ( is_null( $this->default_unit ) ) {
			if ( 1 === count( $units ) ) {
				$this->default_unit = $units[0];
			} else {
				$this->default_unit = 'px';
			}
		}
		return $this->default_unit;
	}

	/**
	 * Get Input Type.
	 */
	protected function get_input_type( $value = '' ) {
		if ( is_numeric( $value ) && in_array( 'num', $this->get_units() ) ) {
			return 'num';
		}
		if ( ! $this->allow_numeric && is_numeric( $value ) ) {
			return 'func';
		}
		if ( $this->str_starts_with( $value, 'var(' ) ) {
			return 'var';
		}
		if ( $this->str_starts_with( $value, 'clamp(' ) ) {
			return 'func';
		}
		if ( $this->str_starts_with( $value, 'calc(' ) ) {
			return 'func';
		}
		return 'std';
	}

	/**
	 * Return css unit from input.
	 */
	protected function get_unit( $input ) {
		if ( $input && is_string( $input ) && ! is_numeric( $input ) ) {
			$non_numeric_string = preg_replace( '/[^0-9.]/', '', $input );
			$unit = str_replace( $non_numeric_string, '', $input );
			return trim( $unit );
		}
	}

	/**
	 * Wrapper method for PHP 8.0 str_starts_with function.
	 */
	protected function str_starts_with( $haystack = '', $needle = '' ) {
		if ( function_exists( 'str_starts_with' ) ) {
			return str_starts_with( $haystack, $needle );
		}
		return ( 0 === strpos( $haystack, $needle ) );
	}

}