<?php
namespace TotalTheme\Customizer\Controls;

use \WP_Customize_Control;

defined( 'ABSPATH' ) || exit;

/**
 * Customizer Ticon Select Control.
 *
 * @package TotalTheme
 * @subpackage Customizer
 * @version 5.6
 */
class Icon_Select extends WP_Customize_Control {

	/**
	 * The control type.
	 */
	public $type = 'wpex_ticon_select';

	/**
	 * Send data to content_template.
	 */
	public function to_json() {
		parent::to_json();

		$value = $this->value();

		// The setting value.
		$this->json['value'] = $value;

		// The data link.
		$this->json['link'] = $this->get_link();

		// The control choices.
		$this->json['choices'] = $this->get_icon_choices( $this->choices );

		// Send svg.
		$this->json['svg'] = $this->get_selected_svg( $value );
	}

	/**
	 * Don't render the control content from PHP, as it's rendered via JS on load.
	 */
	public function render_content() {}

	/**
	 * The control template.
	 */
	public function content_template() {

		?>

		<# if ( data.label ) { #>
			<span class="customize-control-title">{{{data.label}}}</span>
		<# } #>

		<# if ( data.description ) { #>
			<span class="description customize-control-description">{{{ data.description }}}</span>
		<# } #>

		<div class="wpex-customize-icon-select">

			<div>
				<div class="wpex-customize-icon-select__preview <# if ( ! data.svg ) { #>wpex-customize-icon-select__preview--empty<# } #>">
					<div class="wpex-customize-icon-select__svg">{{{ data.svg }}}</div>
					<a href="#" class="wpex-customize-icon-select__remove"><?php wpex_svg( 'material/close' ); ?><span class="screen-reader-text"><?php esc_html_e( 'remove icon', 'total' ); ?></span></a>
				</div>
			</div>

			<button type="button" class="button button-secondary wpex-customize-icon-select__button"><?php echo esc_html__( 'Select Icon', 'total' ); ?></button>

			<div class="wpex-customize-icon-select-modal">
				<div class="wpex-customize-icon-select-modal__inner">
					<span class="screen-reader-text"><label for="wpex-customize-icon-select-search"><?php esc_html_e( 'Search for an icon', 'total' ); ?></label></span>
					<input class="wpex-customize-icon-select-modal__search" id="wpex-customize-icon-select-search" type="search" placeholder="<?php esc_html_e( 'Search for an icon', 'total' ); ?>&hellip;">
					<div class="wpex-customize-icon-select-modal__choices">
						<# _.each( data.choices, function( choice, key ) { #>
							<a href="#" title="{{ choice.name }}" data-value="{{ key }}">{{{ choice.svg }}}</a>
						<# }) #>
					</div>
					<button class="button-primary wpex-customize-icon-select-modal__close"><?php esc_html_e( 'Close', 'total' ); ?></button>
				</div>
			</div>
		</div>

	<?php }

	/**
	 * Shows the selected svg icon.
	 */
	protected function get_selected_svg( $value = '' ) {
		if ( ! $value ) {
			$value = 'shopping-cart';
		}
		if ( false !== strpos( $value, '/' ) ) {
			return wpex_get_svg( $value );
		} else {
			return wpex_get_svg( 'ticons/' . str_replace( 'ticons ticons-', '', $value ) );
		}
	}

	/**
	 * Get icon choices.
	 */
	protected function get_icon_choices( $icons = [] ) {
		$choices = [];
		$icons   =  $icons ?: wpex_ticons_list();
		if ( $icons ) {
			foreach ( $icons as $icon ) {
				if ( empty( $icon ) || 'none' === $icon ) {
					continue;
				}
				$choices[$icon] = [];
				$name = str_replace( '-', ' ', $icon );
				$name = str_replace( '/', ' ', $icon );
				$choices[$icon]['name'] = $name;
				if ( false !== strpos(  $icon, '/' ) ) {
					$choices[$icon]['svg'] = wpex_get_svg( $icon, '1em' );
				} else {
					$choices[$icon]['svg'] = wpex_get_svg( 'ticons/' . str_replace( 'ticons ticons-', '', $icon ), '1em' );
				}

				?>
			<?php }
		}
		return $choices;
	}
}