<?php
namespace TotalTheme\Customizer\Controls;

use \WP_Customize_Control;

defined( 'ABSPATH' ) || exit;

/**
 * Customizer Font Family Control.
 *
 * @package TotalTheme
 * @subpackage Customizer
 * @version 5.5.3
 */
class Font_Family extends WP_Customize_Control {

	/**
	 * The control type.
	 */
	public $type = 'wpex-font-family';

	/**
	 * Render the content
	 */
	public function render_content() {
		$this_val     = $this->value();
		$value_exists = false;
		$admin_color  = get_user_option( 'admin_color' );
		$admin_color  = $admin_color ? ' wpex-customizer-chosen-select--' . $admin_color : '';
		$user_fonts   = wpex_get_registered_fonts();
		$fonts        = wpex_add_custom_fonts();
		$use_chosen   = $user_fonts ? false : true;

		?>

		<label><span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span></label>

		<?php if ( ! empty( $this->description ) ) : ?>
			<span id="_customize-description-<?php echo esc_attr( $this->id ); ?>" class="description customize-control-description"><?php echo wp_kses_post( $this->description ); ?></span>
		<?php endif; ?>

		<?php if ( $use_chosen ) { ?>
			<div class="wpex-customizer-chosen-select<?php echo esc_attr( $admin_color ); ?>">
		<?php } ?>

			<select <?php $this->link(); ?>>

				<option value="" <?php if ( ! $this_val ) echo 'selected="selected"'; ?>><?php esc_html_e( 'Default', 'total' ); ?></option>

				<?php if ( ! empty( $user_fonts ) ) { ?>
					<optgroup label="<?php esc_html_e( 'My Fonts', 'total' ); ?>">
						<?php foreach ( $user_fonts as $font_name => $font_settings ) {
							if ( $font_name === $this_val ) {
								$value_exists = true;
							} ?>
							<option value="<?php echo esc_attr( $font_name ); ?>" <?php selected( esc_attr( $font_name ), $this_val, true ); ?>><?php echo ucfirst( esc_html( $font_name ) ); ?></option>
						<?php } ?>
					</optgroup>
				<?php } ?>

				<?php if ( $fonts && is_array( $fonts ) ) { ?>
					<optgroup label="<?php esc_html_e( 'Custom Fonts', 'total' ); ?>">
						<?php foreach ( $fonts as $font ) {
							if ( $font === $this_val ) {
								$value_exists = true;
							} ?>
							<option value="<?php echo esc_attr( $font ); ?>" <?php selected( esc_attr( $font ), $this_val, true ); ?>><?php echo ucfirst( esc_html( $font ) ); ?></option>
						<?php } ?>
					</optgroup>
				<?php } ?>

				<?php
				// Get Standard font options.
				if ( $std_fonts = wpex_standard_fonts() ) { ?>
					<optgroup label="<?php esc_html_e( 'Standard Fonts', 'total' ); ?>">
						<?php
						// Loop through font options and add to select.
						foreach ( $std_fonts as $font ) {
							if ( $font === $this_val ) {
								$value_exists = true;
							} ?>
							<option value="<?php echo esc_attr( $font ); ?>" <?php selected( esc_attr( $font ), $this_val, true ); ?>><?php echo esc_html( $font ); ?></option>
						<?php } ?>
					</optgroup>
				<?php } ?>

				<?php if ( ! $user_fonts ) { ?>

					<?php
					// Google font options.
					if ( $google_fonts = wpex_google_fonts_array() ) { ?>
						<optgroup label="<?php esc_html_e( 'Google Fonts', 'total' ); ?>">
							<?php
							// Loop through font options and add to select.
							foreach ( $google_fonts as $font ) {
								if ( $font === $this_val ) {
									$value_exists = true;
								} ?>
								<option value="<?php echo esc_attr( $font ); ?>" <?php selected( esc_attr( $font ), $this_val, true ); ?>><?php echo esc_html( $font ); ?></option>
							<?php } ?>
						</optgroup>
					<?php } ?>

				<?php } ?>

				<?php if ( ! empty( $this_val ) && false === $value_exists ) { ?>
					<optgroup label="<?php esc_html_e( 'Non Registered Fonts', 'total' ); ?>">
						<option value="<?php echo esc_attr( $this_val ); ?>" selected="selected"><?php echo ucfirst( esc_html( $this_val ) ); ?></option>
					</optgroup>
				<?php } ?>

			</select>

		<?php if ( $use_chosen ) { ?>
			</div>
		<?php } ?>

	<?php }
}