<?php
namespace TotalTheme\Customizer\Controls;

use WP_Customize_Control;

/**
 * Customizer Blocks Control
 *
 * @package TotalTheme
 * @subpackage Customizer
 * @version 5.5
 */
class Blocks extends WP_Customize_Control {

	/**
	 * The control type.
	 */
	public $type = 'wpex_blocks';

	/**
	 * Enque scripts.
	 */
	public function enqueue() {
		wp_enqueue_script( 'jquery-ui-core' );
		wp_enqueue_script( 'jquery-ui-sortable' );
	}

	/**
	 * Render Control Content.
	 */
	public function render_content() {
		$input_id       = '_customize-input-' . $this->id;
		$description_id = '_customize-description-' . $this->id;
		$value          = $this->get_value();
		$choices        = $this->choices ?? array();

		if ( is_string( $choices ) && is_callable( $choices ) ) {
			$choices = call_user_func( $choices );
		}

		$has_blocks_class = $value ? ' wpex-customize-blocks--has-blocks' : '';
		?>

		<?php if ( ! empty( $this->label ) ) : ?>
			<label for="<?php echo esc_attr( $input_id ); ?>" class="customize-control-title"><?php echo esc_html( $this->label ); ?></label>
		<?php endif; ?>

		<?php if ( ! empty( $this->description ) ) : ?>
			<span id="<?php echo esc_attr( $description_id ); ?>" class="description customize-control-description"><?php echo esc_html( $this->description ); ?></span>
		<?php endif; ?>

		<div class="wpex-customize-blocks<?php echo $has_blocks_class; ?>">

			<div class="wpex-customize-blocks__add-new">
				<select class="wpex-customize-blocks__select">
					<option value=""><?php esc_html_e( 'Select Item', 'total' ); ?></option>
					<?php foreach ( $choices as $key => $name ) {
						echo '<option value="' . esc_attr( $key ) . '">' . esc_html( $name ) . '</option>';
					} ?>
				</select>
				<button type="button" class="wpex-customize-blocks__add-button button button-secondary">+ <?php esc_html_e( 'Add', 'total' ); ?></button>
			</div>

			<div class="wpex-customize-blocks__template">
				<div class="wpex-customize-blocks__item-name"></div>
				<button class="wpex-customize-blocks__delete-item"><span class="dashicons dashicons-no-alt" aria-hidden="true"></span><span class="screen-reader-text"><?php esc_html_e( 'delete item', 'total' ); ?></span></button>
			</div>

			<div class="wpex-customize-blocks__list">
				<?php if ( $value && is_array( $value ) ) {
					foreach ( $value as $value ) {
						$name = $choices[$value] ?? $value;
						?>
						<div class="wpex-customize-blocks__item" data-wpex-key="<?php echo esc_attr( $value ); ?>">
							<div class="wpex-customize-blocks__item-name"><?php echo esc_html( $name ); ?></div>
							<button class="wpex-customize-blocks__delete-item"><span class="dashicons dashicons-no-alt" aria-hidden="true"></span><span class="screen-reader-text"><?php esc_html_e( 'delete item', 'total' ); ?></span></button>
						</div>
					<?php }
				} ?>
			</div>

		</div>

	<?php }

	/**
	 * Return setting value.
	 */
	protected function get_value() {
		$value = $this->value();
		if ( '' === $value ) {
			return array();
		}
		if ( is_string( $value ) ) {
			$value = explode( ',', $value );
		}
		return $value;
	}

}