<?php
defined( 'ABSPATH' ) || exit;

/**
 * Customizer Manager.
 *
 * @package TotalTheme
 * @subpackage Customizer
 * @version 5.4
 */
if ( ! class_exists( 'WPEX_Customizer_Manager' ) ) {
	class WPEX_Customizer_Manager extends WPEX_Customizer {

		/**
		 * Start things up.
		 */
		public function __construct() {
			$this->init_hooks();
		}

		/**
		 * Hook into actions and filters.
		 */
		public function init_hooks() {
			add_action( 'admin_menu', array( $this, 'add_admin_submenu_page' ), 40 );
			add_action( 'admin_init', array( $this, 'register_settings' ) );
		}

		/**
		 * Add sub menu page for the custom CSS input.
		 */
		public function add_admin_submenu_page() {
			add_submenu_page(
				WPEX_THEME_PANEL_SLUG,
				esc_html__( 'Customizer Manager', 'total' ),
				esc_html__( 'Customizer Manager', 'total' ),
				'administrator', // allow admin to decide what "edit_theme_options" roles can edit.
				WPEX_THEME_PANEL_SLUG . '-customizer',
				array( $this, 'create_admin_page' )
			);
		}

		/**
		 * Function that will register admin page settings.
		 */
		public function register_settings() {
			register_setting(
				'wpex_customizer_editor',
				'wpex_disabled_customizer_panels',
				array(
					'type' => 'array',
					'sanitize_callback' => array( $this, 'sanitize_callback' ),
				)
			);
		}

		/**
		 * Sanitize option.
		 */
		public function sanitize_callback( $option ) {
			if ( is_array( $option ) ) {
				$option = array_map( 'wp_strip_all_tags', $option );
			} else {
				$option = array();
			}
			return $option;
		}

		/**
		 * Save option.
		 */
		protected function save_option( $option ) {
			$excluded_panels = array();
			$panels = $this->panels();
			foreach ( $panels as $id => $val ) {
				if ( ! isset( $option[$id] ) ) {
					$excluded_panels[] = $id;
				}
			}
			if ( $excluded_panels ) {
				update_option( 'wpex_disabled_customizer_panels', $excluded_panels, false );
			} else {
				delete_option( 'wpex_disabled_customizer_panels' );
			}
		}

		/**
		 * Settings page output.
		 *
		 */
		public function create_admin_page() {
			wp_enqueue_style( 'wpex-admin-pages' );
			wp_enqueue_script( 'wpex-admin-pages' );

			if ( array_key_exists( 'wpex_customizer_manager_nonce_field', $_POST ) && wp_verify_nonce( $_POST['wpex_customizer_manager_nonce_field'], 'wpex_customizer_manager_nonce_action' ) ) {
				$option = $_POST['wpex_disabled_customizer_panels'] ?? array(); // allow disabling of all fields.
				$this->save_option( $option );
			}

			?>

			<div id="wpex-customizer-manager-admin-page" class="wrap">

				<h1><?php esc_html_e( 'Customizer Manager', 'total' ); ?></h1>

				<p><?php esc_html_e( 'Disable sections in the Customizer that you no longer need. It will NOT alter any options already set in the Customizer or disable sections visible on the front-end of your site.', 'total' ); ?></p>

				<h2 class="nav-tab-wrapper">
					<a href="#" class="nav-tab nav-tab-active"><?php esc_html_e( 'Panels', 'total' ); ?></a>
					<a href="<?php echo esc_url( admin_url( 'customize.php' ) ); ?>" class="nav-tab"><?php esc_html_e( 'Customizer', 'total' ); ?> <span class="dashicons dashicons-external"></span></a>
				</h2>

				<div class="wpex-check-uncheck">
					<a href="#" class="wpex-customizer-check-all"><?php esc_html_e( 'Check all', 'total' ); ?></a> | <a href="#" class="wpex-customizer-uncheck-all"><?php esc_html_e( 'Uncheck all', 'total' ); ?></a>
				</div>

				<form method="post">
					<table class="form-table wpex-customizer-editor-table">
						<?php
						// Get panels.
						$panels = $this->panels();

						// Get disabled panels.
						$disabled_panels = get_option( 'wpex_disabled_customizer_panels' ) ?: array();

						// Loop through panels and add checkbox
						foreach ( $panels as $id => $val ) {
							$title     = $val['title'] ?? $val;
							$condition = $val['condition'] ?? true;

							// Check if option should be hidden
							$is_hidden = isset( $val['condition'] ) && ! call_user_func( $val['condition'] ) ? true : false;

							// Check if a given section is enabled
							$is_enabled = wpex_has_customizer_panel( $id ) ? 'on' : '';
							?>

							<tr valign="top"<?php if ( $is_hidden ) echo ' style="display:none;"'; ?>>
								<th scope="row"><label for="wpex_disabled_customizer_panels[<?php echo esc_attr( $id ); ?>]"><?php echo esc_html( $title ); ?></label></th>
									<td>
									<?php
									// Condition isn't met so add setting as a hidden item
									if ( $is_hidden ) { ?>
										<input type="hidden" id="wpex_disabled_customizer_panels[<?php echo esc_attr( $id ); ?>]" name="wpex_disabled_customizer_panels[<?php echo esc_attr( $id ); ?>]"<?php checked( $is_enabled, 'on' ); ?>>
									<?php }
									// Display setting
									else { ?>
										<input class="wpex-customizer-editor-checkbox" type="checkbox" id="wpex_disabled_customizer_panels[<?php echo esc_attr( $id ); ?>]" name="wpex_disabled_customizer_panels[<?php echo esc_attr( $id ); ?>]"<?php checked( $is_enabled, 'on' ); ?>>
									<?php } ?>
								</td>
							</tr>
						<?php } ?>
					</table>
					<?php wp_nonce_field( 'wpex_customizer_manager_nonce_action', 'wpex_customizer_manager_nonce_field' ); ?>
					<?php submit_button(); ?>
				</form>
			</div>
		<?php }

	}
}
new WPEX_Customizer_Manager;