<?php
namespace TotalTheme\CPT;

use TotalTheme\Meta;

defined( 'ABSPATH' ) || exit;

/**
 * Custom Post Type Meta Blocks.
 *
 * @package TotalTheme
 * @subpackage CPT
 * @version 5.7.0
 */
class Meta_Blocks extends Meta {

	/**
	 * Returns the array meta block choices.
	 */
	public static function choices() {
		return parent::registered_blocks();
	}

	/**
	 * Returns custom post type meta blocks to display.
	 */
	public static function get( $singular = null ) {
		$blocks = [
			'date',
			'author',
			'categories',
			'comments',
		];

		$instance = wpex_get_loop_instance();
		$post_type = get_post_type();

		if ( WPEX_PTU_ACTIVE ) {
			if ( ! $singular ) {
				$singular = ( is_singular() && is_main_query() ) ? true : false;
			}
			if ( $singular ) {
				$ptu_check = wpex_get_ptu_type_mod( $post_type, 'single_meta_blocks' );
				if ( $ptu_check ) {
					$blocks = $ptu_check;
				}
			} else {
				$ptu_check = wpex_get_ptu_type_mod( $post_type, 'entry_meta_blocks' );
				if ( $ptu_check ) {
					$blocks = $ptu_check;
				}
			}
		}

		if ( is_string( $blocks ) ) {
			$blocks = $blocks ? explode( ',', $blocks ) : [];
		}

		if ( $blocks ) {

			/*
			 * Make sure only allowed blocks are displayed.
			 */
			$blocks = array_intersect( $blocks, array_keys( self::choices() ) );
		}

		// Set values equal to keys to make it easier to unset via hooks.
		//$blocks = array_combine( $blocks, $blocks ); // @todo should we enable this?

		/**
		 * Filters the post meta blocks.
		 *
		 * @param array $blocks
		 * @param string $post_type
		 */
		if ( $singular ) {
			$blocks = (array) apply_filters( 'totaltheme/cpt/meta_blocks/singular_blocks', $blocks, $post_type );
		}  else {
			$blocks = (array) apply_filters( 'totaltheme/cpt/meta_blocks/entry_blocks', $blocks, $post_type );
		}

		/*** deprecated ***/
		$blocks = (array) apply_filters( 'wpex_meta_blocks', $blocks, $post_type );

		return $blocks;
	}

	/**
	 * Render custom post type meta blocks.
	 */
	public static function render( $args = [] ) {
		if ( ! isset( $args['blocks'] ) ) {
			$args['blocks'] = self::get();
		}
		parent::render_blocks( $args );
	}

	/**
	 * Echo class attribute for the the custom post type meta blocks wrapper element.
	 */
	public static function wrapper_class( $is_custom = false ) {
		$classes = [
			'meta',
			'wpex-text-sm',
			'wpex-text-3',
		];

		// Don't add margins if displaying a "custom" meta (aka not part of default archive or template design).
		if ( ! $is_custom ) {
			$classes[] = 'wpex-mt-10';
			$singular = is_singular( get_post_type() );

			if ( $singular ) {
				$classes[] = 'wpex-mb-20';
			} else {
				$columns = (int) wpex_get_grid_entry_columns();
				if ( 1 === $columns ) {
					$classes[] = 'wpex-mb-20';
				} else {
					$classes[] = 'wpex-mb-15';
				}
			}
		}

		// Remove margin on last li element.
		$classes[] = 'wpex-last-mr-0';

		if ( ! $is_custom && $singular ) {

			/**
			 * Filters the custom post type single meta element classes.
			 *
			 * @param array $classes
			 */
			$classes = (array) apply_filters( 'totaltheme/cpt/meta_blocks/singular_wrapper_class', $classes );

			/*** deprecated ***/
			$classes = (array) apply_filters( 'wpex_cpt_single_meta_class', $classes );
		} else {

			/**
			 * Filters the custom post type entry meta element classes.
			 *
			 * @param array $classes
			 */
			$classes = (array) apply_filters( 'totaltheme/cpt/meta_blocks/entry_wrapper_class', $classes );

			/*** deprecated ***/
			$classes = (array) apply_filters( 'wpex_cpt_entry_meta_class', $classes );
		}

		if ( $classes ) {
			echo 'class="' . esc_attr( implode( ' ', $classes ) ) . '"';
		}
	}
}