<?php
defined( 'ABSPATH' ) || exit;

/**
 * Returns array of default card styles.
 */
function wpex_get_default_card_styles() {
	$card_styles = [];

	$card_categories = [
		'title' => [
			'name' => esc_html__( 'Title', 'total' ),
		],
		'post-content' => [
			'name' => esc_html__( 'Post Content', 'total' ),
		],
		'image' => [
			'name' => esc_html__( 'Image', 'total' ),
		],
		'video' => [
			'name' => esc_html__( 'Video', 'total' ),
		],
		'toggle' => [
			'name' => esc_html__( 'Toggle', 'total' ),
		],
		'simple' => [
			'name' => esc_html__( 'Simple', 'total' ),
			'count' => 9,
		],
		'news' => [
			'name' => esc_html__( 'News', 'total' ),
			'count' => 6,
		],
		'blog' => [
			'name' => esc_html__( 'Blog', 'total' ),
			'count' => 21,
		],
		'blog-list' => [
			'name' => esc_html__( 'Blog List', 'total' ),
			'count' => 21,
		],
		'magazine' => [
			'name' => esc_html__( 'Magazine', 'total' ),
			'count' => 2,
		],
		'magazine-list' => [
			'name' => esc_html__( 'Magazine List', 'total' ),
			'count' => 2,
		],
		'numbered-list' => [
			'name' => esc_html__( 'Numbered List', 'total' ),
			'count' => 6,
		],
		'testimonial' => [
			'name' => esc_html__( 'Testimonial', 'total' ),
			'count' => 9,
		],
		'staff' => [
			'name' => esc_html__( 'Staff', 'total' ),
			'count' => 8,
		],
		'portfolio' => [
			'name' => esc_html__( 'Portfolio', 'total' ),
			'count' => 6,
		],
		'product' => [
			'name' => esc_html__( 'Product', 'total' ),
			'count' => 4,
		],
		'search' => [
			'name' => esc_html__( 'Search', 'total' ),
			'count' => 6,
		],
		'icon-box' => [
			'name' => esc_html__( 'Icon Box', 'total' ),
			'count' => 6,
		],
	];

	foreach ( $card_categories as $key => $val ) {
		if ( isset( $val['template'] ) ) {
			$card_styles[$key] = [
				'name' => $val['name'],
			];
			continue;
		}
		$count = $val['count'] ?? 1;
		$x = 1;
		while ( $x <= $count ) {
			if ( 1 === $count ) {
				$name = $val['name'];
			} else {
				$name = $val['name'] . ' ' . $x;
			}
			$card_styles[sanitize_key( $key . '_' . $x )] = [
				'name' => $name
			];
			$x++;
		}
	}

	if ( WPEX_WOOCOMMERCE_ACTIVE ) {
		$card_styles['woocommerce'] = [
			'name' => 'WooCommerce',
		];
	}

	return $card_styles;
}

/**
 * Returns array of card styles.
 */
function wpex_get_card_styles() {
	$card_styles = [];

	/**
	 * Checks if default cards are enabled.
	 *
	 * @param bool $check
	 */
	$default_cards_enabled = (bool) apply_filters( 'wpex_has_default_card_styles', true );

	if ( $default_cards_enabled ) {
		$card_styles = wpex_get_default_card_styles();
	}

	/**
	 * Filters the theme card styles list.
	 *
	 * @param array $card_styles
	 */
	$card_styles = (array) apply_filters( 'wpex_card_styles', $card_styles );

	return $card_styles;
}

/**
 * Return an array of card styles.
 */
function wpex_choices_card_styles() {
	$choices = [
		'' => '&#8211; ' . esc_html__( 'None', 'total' ) . ' &#8211;',
	];

	$card_styles = wpex_get_card_styles();

	foreach ( $card_styles as $card_id => $card_settings ) {
		$choices[$card_id] = $card_settings['name'];
	}

	return $choices;
}

/**
 * Return dropdown select of card styles.
 */
function wpex_card_select( $args = [] ) {
	$defaults = [
		'name'     => 'card_style',
		'selected' => '',
		'id'       => 'wpex_card_style',
		'class'    => 'wpex-card-select',
		'label'    => 0,
	];

	$parsed_args = wp_parse_args( $args, $defaults );

	$select = '';

	if ( $parsed_args['label'] ) {
		$select .= '<label for="' . esc_attr( $parsed_args['name'] ) . '">' . esc_html__( 'Select a card', 'total' ) . ':</label>';
	}

	$select .= '<select name="' . esc_attr( $parsed_args['name'] ) . '"';
		if ( $parsed_args['id'] ) {
			$select .= ' id="' . esc_attr( $parsed_args['id'] ) . '"';
		}
		if ( $parsed_args['class'] ) {
			$select .= ' class="' . esc_attr( $parsed_args['class'] ) . '"';
		}
	$select .= '>';

	$choices = wpex_choices_card_styles();

	if ( $choices ) {
		foreach ( $choices as $name => $label ) {
			$select .= '<option value="' . esc_attr( $name ) . '" ' . selected( $name, $parsed_args['selected'], false ) . '>' . esc_html__( $label ) . '</option>';
		}
	}

	$select .= '</select>';

	return $select;
}

/**
 * Display card.
 */
function wpex_card( $args = [] ) {
	echo wpex_get_card( $args );
}

/**
 * Get card.
 */
function wpex_get_card( $args = [] ) {
	$card = new WPEX_Card( $args );
	return $card->render();
}