<?php
namespace TotalTheme\Actions;

use TotalTheme\Scripts\CSS;
use TotalTheme\Scripts\JS;

defined( 'ABSPATH' ) || exit;

/**
 * Hooks into wp_enqueue_scripts.
 *
 * @package TotalTheme
 * @subpackage Actions
 * @version 5.6.1
 */
class WP_Enqueue_Scripts {

	/**
	 * Class instance.
	 */
	private static $instance;

	/**
	 * Create or retrieve the instance of Custom_Actions.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
			static::$instance->init();
		}
		return static::$instance;
	}

	/**
	 * Start things up.
	 */
	protected function init() {
		$this->register_enqueue_css();
		$this->register_enqueue_js();
		$this->remove_styles();
	}

	/**
	 * CSS.
	 */
	public function register_enqueue_css() {
		CSS::register();
		CSS::enqueue();
	}

	/**
	 * JS.
	 */
	public function register_enqueue_js() {
		JS::register();
		JS::enqueue();
	}

	/**
	 * Remove styles.
	 */
	protected function remove_styles() {
		wp_dequeue_style( 'classic-theme-styles'  );
	}

}