<?php
use TotalTheme\Integration\WPBakery\Shortcode_Inline_Style as WPB_Style;

defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'vcex_do_shortcode_function' ) ) {
	return;
}

$html = '';

$title_font_size = 'wpex-text-md';

if ( ! empty( $this->args['title_font_size'] )
	&& array_key_exists( $this->args['title_font_size'], wpex_utl_font_sizes() )
) {
	$title_font_size = 'wpex-text-' . $this->args['title_font_size'];
}

if ( $title_font_size ) {
	$title_font_size = ' ' . trim( $title_font_size );
}

if ( $this->post_id ) {
	$content_id = sanitize_html_class( get_post_field( 'post_name', $this->post_id ) );
} else {
	$content_id = 'wpex-card-toggle_1--' . sanitize_html_class( $this->get_var( 'running_count' ) );
}

$atts = [
	'heading'          => $this->get_the_title(),
	'content_id'       => $content_id,
	'heading_el_class' => 'wpex-card-title wpex-heading wpex-child-inherit-color' . $title_font_size,
	'icon_position'    => 'right',
	'heading_tag'      => $this->get_title_tag(),
	'animate'          => 'true',
	'icon_type'        => 'angle',
	'state'            => 'closed',
];

$excerpt_args = [
	'length' => '-1',
];

if ( $this->post_id ) {
	$html .= WPB_Style::instance()->get_style( $this->post_id );
}

$html .= vcex_do_shortcode_function( 'vcex_toggle', $atts, $this->get_the_excerpt( $excerpt_args ) );

return $html;