<?php
defined( 'ABSPATH' ) || exit;

/**
 * Used for custom cards created at Theme Panel > Custom Cards.
 */
$template_id = $this->get_template_id();

if ( ! $template_id ) {
	return;
}

$content = get_post_field( 'post_content', $template_id );

if ( empty( $content ) ) {
	return;
}

$template_type    = '';
$template_content = '';

if ( false !== strpos( $content, '[vc_row' ) ) {
	$template_type = 'wpbakery';
} elseif ( has_blocks( get_post( $template_id ) ) ) {
	$template_type = 'gutenberg';
} elseif ( class_exists( 'Elementor\\Plugin' ) && Elementor\Plugin::$instance->documents->get( $template_id )->is_built_with_elementor() ) {
	$template_type = 'elementor';
}

$file = trailingslashit( WPEX_THEME_DIR ) . 'cards/template/' . $template_type . '.php';

if ( file_exists( $file ) ) {
	$template_content = require $file;
}

return $template_content;