<?php
defined( 'ABSPATH' ) || exit;

$has_link = $this->has_link();
$html = '';

$inner_class = 'wpex-card-inner';

if ( $has_link ) {

	if ( ! empty( $this->args['thumbnail_overlay_style'] ) && in_array( $this->args['thumbnail_overlay_style'], [ 'thumb-swap', 'thumb-swap-title' ] ) ) {
		$inner_class .= ' overlay-parent';
	}

	$html .= $this->get_link_open( array(
		'class' => $inner_class . ' wpex-no-underline wpex-inherit-color',
		'attributes' => array(
			'aria-label' => get_the_title( $this->post_id ),
		),
	) );
} else {
	$html .= '<div class="' . esc_attr( $inner_class ) . '">';
}

$html .= '<div class="wpex-card-inner wpex-relative wpex-text-center wpex-p-15 wpex-surface-1 wpex-border wpex-border-solid wpex-border-gray-200">';

	// Media
	$html .= $this->get_media( array(
		'class' => 'wpex-mb-15',
		'link' => false,
	) );

	// Details
	$html .= '<div class="wpex-card-details wpex-last-mb-0">';

		// Title
		$html .= $this->get_title( array(
			'class' => 'wpex-heading wpex-text-md wpex-mb-5',
			'link_class' => 'wpex-inherit-color-important',
			'link' => false,
		) );

		// Price
		$html .= $this->get_price( array(
			'class' => 'wpex-text-accent wpex-font-semibold',
			'link' => false,
		) );

	$html .= '</div>';

$html .= '</div>';

return $html;