/* jshint esversion: 6 */
if ( 'function' !== typeof window.wpexToggleBar ) {
	window.wpexToggleBar = ( context ) => {
		const toggleBar = document.querySelector( '#toggle-bar-wrap' );

		if ( ! toggleBar ) {
			return;
		}

		const toggleBarToggle = () => {
			const rememberState = ( 'true' === toggleBar.dataset.rememberState );
			const toggleButton  = document.querySelector( '#toggle-bar-button' );

			const getState = () => {
				return toggleBar.dataset.state || 'hidden';
			};

			const setCookie = ( state ) => {
				if ( rememberState ) {
					document.cookie = 'total_togglebar_state=' + state + '; path=/; Max-Age=604800; SameSite=Strict; Secure';
				}
			};

			const openBar = () => {
				toggleBar.classList.add( 'active-bar' );
				toggleBar.dataset.state = 'visible';
				if ( toggleButton ) {
					toggleButton.setAttribute( 'aria-expanded', 'true' );
				}
				setCookie( 'visible' );
			};

			const closeBar = () => {
				toggleBar.classList.remove( 'active-bar' );
				toggleBar.dataset.state = 'hidden';
				if ( toggleButton ) {
					toggleButton.setAttribute( 'aria-expanded', 'false' );
				}
				setCookie( 'hidden' );
			};

			const onDocClick = ( event ) => {
				const button = event.target.closest( 'a.toggle-bar-btn, a.togglebar-toggle, .togglebar-toggle > a' );
				if ( ! button ) {
					if ( 'visible' === getState() && toggleBar.classList.contains( 'close-on-doc-click' ) && ! event.target.closest( '#toggle-bar-wrap' ) ) {
						closeBar();
					}
					return;
				}
				if ( 'hidden' === getState() ) {
					openBar();
				} else {
					closeBar();
				}
				event.preventDefault();
				event.stopPropagation();
			};

			document.addEventListener( 'click', onDocClick );
		};

		const toggleBarDismiss = () => {
			const onDocClick = ( event ) => {
				const button = event.target.closest( '.toggle-bar-dismiss__button' );
				if ( ! button ) {
					return;
				}
				toggleBar.parentNode.removeChild( toggleBar );
				if ( 'true' === toggleBar.dataset.rememberState ) {
					document.cookie = 'total_togglebar_state=hidden; path=/; Max-Age=604800; SameSite=Strict; Secure';
				}
				event.preventDefault();
			};
			document.addEventListener( 'click', onDocClick );
		};

		const allowToggle = toggleBar.dataset.allowToggle;

		if ( allowToggle && 'false' !== allowToggle ) {
			toggleBarToggle( toggleBar );
		} else {
			toggleBarDismiss( toggleBar );
		}

	};
}

if ( document.readyState === 'interactive' || document.readyState === 'complete' ) {
	setTimeout( wpexToggleBar, 0 );
} else {
	document.addEventListener( 'DOMContentLoaded', wpexToggleBar, false );
}