/* jshint esversion: 6 */
( function() {

	if ( undefined === typeof window.wpexTemplatesData.templates || undefined === window.vc.template ) {
		return;
	}

	const templates = window.wpexTemplatesData.templates || [];

	if ( ! templates ) {
		return;
	}

	const templatesTab = document.querySelector( '[data-vc-ui-element-target="[data-tab=wpex_section_templates]"]' );

	const onTabOpen = ( event ) => {
		const target = event.target;
		if ( ! target.closest( '.vc_ui-tabs-line-trigger' ) ) {
			return;
		}

		let renderedHtml = '';
		const templateHtml = jQuery( '#wpex_template-item' ).html();
		const compiledTemplate = vc.template( templateHtml, );

		templates.forEach( function ( item ) {
			renderedHtml += compiledTemplate( item );
		} );

		document.querySelector( '.wpex-vc-template-list' ).innerHTML = renderedHtml;

		document.removeEventListener( 'click', onTabOpen );
	};

	const filterLinks = ( event ) => {
		const target = event.target;

		if ( ! target.closest( '.wpex-vc-template-list__filter-button' ) ) {
			return;
		}

		event.preventDefault();
		event.stopPropagation();

		target.setAttribute( 'aria-pressed', 'true' );

		const category = target.dataset.category;

		target.parentElement.querySelectorAll( 'a' ).forEach( ( filterLink ) => {
			if ( filterLink.isSameNode( target ) ) {
				return;
			}
			filterLink.setAttribute( 'aria-pressed', 'false' );
		} );

		document.querySelectorAll( '.wpex-vc-template-list__item' ).forEach( ( filterItem ) => {
			filterItem.classList.remove( 'wpex-vc-template-list__item--hidden' );
			if ( '*' !== category && category !== filterItem.dataset.wpexCategory ) {
				filterItem.classList.add( 'wpex-vc-template-list__item--hidden' );
			}
		} );
	};


	// Add event listeners.
	document.addEventListener( 'click', filterLinks );

	if ( templatesTab ) {
		document.addEventListener( 'click', onTabOpen );
	}

} ) ();