if ( 'function' !== typeof window.wpexWcCartOverlay ) {
	window.wpexWcCartOverlay = function() {
		const cartOverlay = document.querySelector( '#wpex-cart-overlay' );

		if ( ! cartOverlay ) {
			return;
		}

		let toggleBtn = null;
		let isOpen = false;
		const html = document.querySelector( 'html' );
		const targets = 'a.toggle-cart-widget, li.toggle-cart-widget > a, li.toggle-header-cart > a, .wpex-header-cart-icon button';

		const setFocus = () => {
			const focus = ( event ) => {
				if ( 'object' === typeof wpex && 'function' === typeof wpex.focusOnElement ) {
					wpex.focusOnElement( cartOverlay );
				}
				cartOverlay.removeEventListener( 'transitionend', focus ); // remove event as it keeps triggering.
			};

			// Focus on the search when opening after transition is complete to prevent issues.
			cartOverlay.addEventListener( 'transitionend', focus );
		};

		const returnFocus = () => {
			if ( toggleBtn ) {
				toggleBtn.focus();
			}
		};

		const show = () => {
			isOpen = true;
			cartOverlay.classList.add( 'active' );
			html.classList.add( 'html-noscroll' );

			document.querySelectorAll( targets ).forEach( function( element ) {
				element.classList.add( 'active' );
				element.setAttribute( 'aria-expanded', 'true' );
			} );

			if ( 'function' === typeof jQuery ) {
				jQuery( document ).trigger( 'show.wpex.menuCart' );
			}

			setFocus();
		};

		const hide = () => {
			isOpen = false;
			cartOverlay.classList.remove( 'active' );
			html.classList.remove( 'html-noscroll' );
			document.querySelectorAll( targets ).forEach( function( element ) {
				element.classList.remove( 'active' );
				element.setAttribute( 'aria-expanded', 'false' );
			} );
			returnFocus();
		};

		const onDocClick = ( event ) => {
			var target = event.target.closest( targets );
			if ( ! target ) {
				if ( ! event.target.closest( '#wpex-cart-overlay .wpex-inner' ) && isOpen ) {
					hide();
				}
				return;
			}
			toggleBtn = target;
			if ( toggleBtn.classList.contains( 'go-to-shop' ) ) {
				return;
			}
			event.preventDefault();
			if ( isOpen ) {
				hide();
			} else {
				show();
			}
		};

		const onKeydown = ( event ) => {
			if ( 'Escape' === event.key && isOpen ) {
				hide();
			}
		};

		// Add event listeners.
		document.addEventListener( 'click', onDocClick );
		document.addEventListener( 'keydown', onKeydown );
	};
}

if ( document.readyState === 'interactive' || document.readyState === 'complete' ) {
	setTimeout( wpexWcCartOverlay, 0 );
} else {
	document.addEventListener( 'DOMContentLoaded', wpexWcCartOverlay, false );
}