<?php
namespace TotalThemeCore\WPBakery\Params;

use TotalThemeCore\Vcex\Setting_Choices as Vcex_Setting_Choices;

defined( 'ABSPATH' ) || exit;

/**
 * WPBakery Param => Select Buttons.
 *
 * @package TotalThemeCore
 * @version 1.4.6
 */
final class Select_Buttons {

	public static function output( $settings, $value ) {
		$wrap_classes = array(
			'vcex-select-buttons-param',
			'vcex-custom-select',
			'vcex-noselect',
		);

		$choices = array();

		if ( isset( $settings['choices'] ) ) {
			$vcex_choices = new Vcex_Setting_Choices( $settings['choices'] );
			$choices = $vcex_choices->choices;
		}

		if ( ! $choices ) {
			return '<input type="text" class="wpb_vc_param_value '
					. esc_attr( $settings['param_name'] ) . ' '
					. esc_attr( $settings['type'] ) . '" name="' . esc_attr( $settings['param_name'] ) . '" value="' . esc_attr( $value ) . '">';
		}

		$output = '<div class="' . esc_attr( implode( ' ', $wrap_classes ) ) . '">';

		if ( ! $value ) {
			if ( isset( $settings['std'] ) ) {
				$value = $settings['std'];
			} else {
				$temp_choices = $choices;
				reset( $temp_choices );
				$value = key( $temp_choices );
			}
		}

		foreach ( $choices as $id => $label ) {

			$choice_class = array( 'vcex-opt' );

			if ( $id == $value ) {
				$choice_class[] = 'vcex-active';
			}
			if ( $id ) {
				$choice_class[] = 'vcex-opt-' . sanitize_html_class( $id );
			}

			if ( ! defined( 'TOTAL_THEME_ACTIVE' ) ) {
				$label = str_replace( 'ticon', 'fa', $label );
			}

			$output .= '<button class="' . esc_attr( implode( ' ', $choice_class ) ) . '" data-value="' . esc_attr( $id )  . '">' . wp_kses_post( $label ) . '</button>';

		}

		$output .= '<input name="' . esc_attr( $settings['param_name'] ) . '" class="vcex-hidden-input wpb-input wpb_vc_param_value  ' . esc_attr( $settings['param_name'] ) . ' ' . esc_attr( $settings['type'] ) . '_field" type="hidden" value="' . esc_attr( $value ) . '">';

		$output .= '</div>';

		return $output;
	}

}