<?php
namespace TotalThemeCore\WPBakery\Params;

defined( 'ABSPATH' ) || exit;

/**
 * WPBakery Param => Icon Select.
 *
 * @package TotalThemeCore
 * @version 1.5
 * @todo Finish Implementation
 */
final class Icon_Select {

	public static function output( $settings, $value ) {
		$choices = $settings['choices'] ?? [];

		if ( ! $choices || ! function_exists( 'wpex_svg' ) || ! function_exists( 'wpex_get_svg' ) ) {
			return;
		}

		$output = '';
		$is_empty = ( $value && 'none' !== $value ) ? false : true;

		ob_start();

		?>

		<div class="vcex-param-icon-select">

			<div>
				<div class="vcex-param-icon-select__preview<?php ( $is_empty ) ? ' vcex-param-icon-select__preview--empty' : ''; ?>">
					<?php if ( $value ) {
						echo '<div class="vcex-param-icon-select__svg">' . self::get_svg( $value ) . '</div>';
					} ?>
					<a href="#" class="vcex-param-icon-select__remove"><?php wpex_svg( 'material/close' ); ?><span class="screen-reader-text"><?php esc_html_e( 'remove icon', 'total-theme-core' ); ?></span></a>
				</div>
			</div>

			<button type="button" class="button button-secondary vcex-param-icon-select__button"><?php echo esc_html__( 'Select Icon', 'total-theme-core' ); ?></button>

			<div class="vcex-param-icon-select-modal">
				<div class="vcex-param-icon-select-modal__inner">
					<span class="screen-reader-text"><label for="vcex-param-icon-select-search"><?php esc_html_e( 'Search for an icon', 'total-theme-core' ); ?></label></span>
					<input class="vcex-param-icon-select-modal__search" id="vcex-param-icon-select-search" type="search" placeholder="<?php esc_html_e( 'Search for an icon', 'total-theme-core' ); ?>&hellip;">
					<div class="vcex-param-icon-select-modal__choices">
						<?php foreach ( $choices as $choice ) {
							$choice_name = str_replace( '/', ' ', $choice);
							$choice_name = str_replace( '-', ' ', $choice);
							$choice_svg = self::get_svg( $choice );
							if ( $choice_svg ) {
								echo '<a href="#" title="' . esc_attr( ucfirst( $choice_name ) ) . '" data-value="' . $choice . '">' . $choice_svg . '</a>';
							}
						} ?>
					</div>
					<button class="button-primary vcex-param-icon-select-modal__close"><?php esc_html_e( 'Close', 'total-theme-core' ); ?></button>
				</div>
			</div>
		</div>

		<?php
		$output .= ob_get_clean();

		$output .= '<input name="' . esc_attr( $settings['param_name'] ) . '" class="vcex-hidden-input wpb-input wpb_vc_param_value  ' . esc_attr( $settings['param_name'] ) . ' ' . esc_attr( $settings['type'] ) . '_field" type="hidden" value="' . esc_attr( $value ) . '">';

		$output .= '</div>';

		return $output;
	}

	protected static function get_svg( $icon ) {
		if ( false !== strpos(  $icon, '/' ) ) {
			return wpex_get_svg( $icon, '1em' );
		} else {
			return wpex_get_svg( 'ticons/' . str_replace( 'ticons ticons-', '', $icon ), '1em' );
		}
	}

}