<?php
namespace TotalThemeCore\WPBakery\Map;

use \VCEX_Recent_News_Shortcode;

defined( 'ABSPATH' ) || exit;

/**
 * Class registers the vcex_recent_news shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.4.9
 */
final class Vcex_Recent_News {

	/**
	 * Instance.
	 */
	private static $instance;

	/**
	 * Create or retrieve the class instance.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
			static::$instance->init_hooks();
		}

		return static::$instance;
	}

	/**
	 * Hook into actions and filters.
	 */
	public function init_hooks() {
		add_action( 'vc_after_mapping', array( $this, 'vc_after_mapping' ) );
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public function vc_after_mapping() {
		vc_lean_map( 'vcex_recent_news', array( $this, 'map' ) );

		$vc_action = vc_request_param( 'action' );

		// Auto complete filters
		if ( 'vc_get_autocomplete_suggestion' === $vc_action || 'vc_edit_form' === $vc_action ) {

			// Include categories.
			add_filter(
				'vc_autocomplete_vcex_recent_news_include_categories_callback',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Categories::callback'
			);
			add_filter(
				'vc_autocomplete_vcex_recent_news_include_categories_render',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Categories::render'
			);

			// Exclude categories.
			add_filter(
				'vc_autocomplete_vcex_recent_news_exclude_categories_callback',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Categories::callback'
			);
			add_filter(
				'vc_autocomplete_vcex_recent_news_exclude_categories_render',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Categories::render'
			);

			// Author.
			add_filter(
				'vc_autocomplete_vcex_recent_news_author_in_callback',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Users::callback'
			);
			add_filter(
				'vc_autocomplete_vcex_recent_news_author_in_render',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Users::render'
			);

			// Categories taxonomy select.
			add_filter(
				'vc_autocomplete_vcex_recent_news_categories_taxonomy_callback',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Taxonomies::callback'
			);
			add_filter(
				'vc_autocomplete_vcex_recent_news_categories_taxonomy_render',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Taxonomies::render'
			);

		}

		if ( 'vc_edit_form' === vc_post_param( 'action' ) ) {
			add_filter(
				'vc_edit_form_fields_attributes_vcex_recent_news',
				[ $this, 'edit_fields' ],
				10
			);
		}
	}

	/**
	 * Edit form fields.
	 */
	public function edit_fields( $atts ) {
		$atts = VCEX_Recent_News_Shortcode::parse_deprecated_attributes( $atts );
		return $atts;
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public function map() {
		return [
			'name'        => esc_html__( 'Recent News', 'total-theme-core' ),
			'description' => esc_html__( 'Posts with calendar style date', 'total-theme-core' ),
			'base'        => 'vcex_recent_news',
			'category'    => vcex_shortcodes_branding(),
			'icon'        => 'vcex_element-icon vcex_element-icon--recent-news',
			'params'      => VCEX_Recent_News_Shortcode::get_params(),
		];
	}

}