<?php
namespace TotalThemeCore\WPBakery\Map;

use VCEX_Image_Swap_Shortcode as Shortcode;

use TotalThemeCore\Vcex\WPBakery\Helpers as WPBakery_Helpers;
use TotalThemeCore\Vcex\WPBakery\Views\Backend\Image_Before_After\View as Backend_View;

defined( 'ABSPATH' ) || exit;

/**
 * Class registers the vcex_image_swap shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.5.1
 */
final class Vcex_Image_Swap {

	/**
	 * Instance.
	 *
	 * @access private
	 * @var object Class object.
	 */
	private static $instance;

	/**
	 * Create or retrieve the class instance.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
			static::$instance->init_hooks();
		}

		return static::$instance;
	}

	/**
	 * Hook into actions and filters.
	 */
	public function init_hooks() {
		add_action( 'vc_after_mapping', [ $this, 'vc_after_mapping' ] );

		if ( is_admin() ) {
			Backend_View::instance();
		}
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public function vc_after_mapping() {
		vc_lean_map( 'vcex_image_swap', [ $this, 'map' ] );

		if ( 'vc_edit_form' === vc_post_param( 'action' ) ) {
			add_filter( 'vc_edit_form_fields_attributes_vcex_image_swap', [ $this, 'edit_fields' ], 10 );
		}
	}

	/**
	 * Edit form fields.
	 */
	public function edit_fields( $atts ) {
		$atts = Shortcode::parse_deprecated_attributes( $atts );
		return $atts;
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public function map() {
		return [
			'name'             => esc_html__( 'Image Swap', 'total-theme-core' ),
			'description'      => esc_html__( 'Double Image Hover Effect', 'total-theme-core' ),
			'base'             => 'vcex_image_swap',
			'icon'             => 'vcex_element-icon vcex_element-icon--image-swap',
			'category'         => vcex_shortcodes_branding(),
			'params'           => Shortcode::get_params(),
			'admin_enqueue_js' => WPBakery_Helpers::get_backend_view_js( 'image-before-after' ),
			'js_view'          => 'vcexBackendViewImageBeforeAfter',
		];
	}

}